/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class ValueSerializer<T extends Value>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;

    public ValueSerializer(Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public ValueSerializer<T> duplicate() {
        return new ValueSerializer<T>(this.type);
    }

    @Override
    public T createInstance() {
        return (T)((Value)InstantiationUtil.instantiate(this.type));
    }

    @Override
    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Value)KryoUtils.copy(from, this.kryo, this));
    }

    @Override
    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Value)KryoUtils.copy(from, reuse, this.kryo, this));
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return (T)this.deserialize((T)this.createInstance(), source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (this.copyInstance == null) {
            this.copyInstance = (Value)InstantiationUtil.instantiate(this.type);
        }
        this.copyInstance.read(source);
        this.copyInstance.write(target);
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ValueSerializer) {
            ValueSerializer other = (ValueSerializer)obj;
            return other.canEqual(this) && this.type == other.type;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ValueSerializer;
    }
}

