/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class WritableSerializer<T extends Writable>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;
    private transient Kryo kryo;
    private transient T copyInstance;

    public WritableSerializer(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public T createInstance() {
        if (this.typeClass == NullWritable.class) {
            return (T)NullWritable.get();
        }
        return (T)((Writable)InstantiationUtil.instantiate(this.typeClass));
    }

    @Override
    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Writable)KryoUtils.copy(from, this.kryo, this));
    }

    @Override
    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Writable)KryoUtils.copy(from, reuse, this.kryo, this));
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        record.write((DataOutput)target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.readFields((DataInput)source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.ensureInstanceInstantiated();
        this.copyInstance.readFields((DataInput)source);
        this.copyInstance.write((DataOutput)target);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public WritableSerializer<T> duplicate() {
        return new WritableSerializer<T>(this.typeClass);
    }

    private void ensureInstanceInstantiated() {
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.typeClass);
        }
    }

    @Override
    public int hashCode() {
        return this.typeClass.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WritableSerializer) {
            WritableSerializer other = (WritableSerializer)obj;
            return other.canEqual(this) && this.typeClass == other.typeClass;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof WritableSerializer;
    }
}

