/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Internal
public final class GlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    private static GlobalConfiguration SINGLETON = null;
    private final Configuration config = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GlobalConfiguration get() {
        Class<GlobalConfiguration> clazz = GlobalConfiguration.class;
        synchronized (GlobalConfiguration.class) {
            if (SINGLETON == null) {
                SINGLETON = new GlobalConfiguration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLETON;
        }
    }

    private GlobalConfiguration() {
    }

    public static String getString(String key, String defaultValue) {
        return GlobalConfiguration.get().config.getString(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return GlobalConfiguration.get().config.getLong(key, defaultValue);
    }

    public static int getInteger(String key, int defaultValue) {
        return GlobalConfiguration.get().config.getInteger(key, defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        return GlobalConfiguration.get().config.getFloat(key, defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return GlobalConfiguration.get().config.getBoolean(key, defaultValue);
    }

    public static void loadConfiguration(String configDir) {
        if (configDir == null) {
            LOG.warn("Given configuration directory is null, cannot load configuration");
            return;
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            LOG.warn("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
            return;
        }
        if (confDirFile.isFile()) {
            File file = new File(configDir);
            if (configDir.endsWith(".xml")) {
                GlobalConfiguration.get().loadXMLResource(file);
            } else if (configDir.endsWith(".yaml")) {
                GlobalConfiguration.get().loadYAMLResource(file);
            } else {
                LOG.warn("The given configuration has an unknown extension.");
                return;
            }
            return;
        }
        File[] xmlFiles = GlobalConfiguration.filterFilesBySuffix(confDirFile, ".xml");
        File[] yamlFiles = GlobalConfiguration.filterFilesBySuffix(confDirFile, new String[]{".yaml", ".yml"});
        if (!(xmlFiles != null && xmlFiles.length != 0 || yamlFiles != null && yamlFiles.length != 0)) {
            LOG.warn("Unable to get the contents of the config directory '" + configDir + "' (" + confDirFile.getAbsolutePath() + ").");
            return;
        }
        for (File f : xmlFiles) {
            GlobalConfiguration.get().loadXMLResource(f);
        }
        for (File f : yamlFiles) {
            GlobalConfiguration.get().loadYAMLResource(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadYAMLResource(File file) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] comments = line.split("#", 2);
                    String conf = comments[0];
                    if (conf.length() <= 0) continue;
                    String[] kv = conf.split(": ", 2);
                    if (kv.length == 1) {
                        LOG.warn("Error while trying to split key and value in configuration file " + file + ": " + line);
                        continue;
                    }
                    String key = kv[0].trim();
                    String value = kv[1].trim();
                    if (key.length() == 0 || value.length() == 0) {
                        LOG.warn("Error after splitting key and value in configuration file " + file + ": " + line);
                        continue;
                    }
                    LOG.debug("Loading configuration property: {}, {}", (Object)key, (Object)value);
                    this.config.setString(key, value);
                }
            }
            catch (IOException e) {
                LOG.error("Error parsing YAML configuration.", (Throwable)e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Cannot to close reader with IOException.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXMLResource(File file) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(file);
            if (doc == null) {
                LOG.warn("Cannot load configuration: doc is null");
                return;
            }
            Element root = doc.getDocumentElement();
            if (root == null) {
                LOG.warn("Cannot load configuration: root is null");
                return;
            }
            if (!"configuration".equals(root.getNodeName())) {
                return;
            }
            NodeList props = root.getChildNodes();
            int propNumber = -1;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                for (int i = 0; i < props.getLength(); ++i) {
                    Element property;
                    Node propNode = props.item(i);
                    String key = null;
                    String value = null;
                    if (propNode instanceof Text || !(propNode instanceof Element) || !"property".equals((property = (Element)propNode).getNodeName())) continue;
                    ++propNumber;
                    NodeList propChildren = property.getChildNodes();
                    if (propChildren == null) {
                        LOG.warn("Error while reading configuration: property has no children, skipping...");
                        continue;
                    }
                    for (int j = 0; j < propChildren.getLength(); ++j) {
                        Text t;
                        Node propChild = propChildren.item(j);
                        if (!(propChild instanceof Element)) continue;
                        if ("key".equals(propChild.getNodeName()) && propChild.getChildNodes() != null && propChild.getChildNodes().getLength() == 1 && propChild.getChildNodes().item(0) instanceof Text) {
                            t = (Text)propChild.getChildNodes().item(0);
                            key = t.getTextContent();
                        }
                        if (!"value".equals(propChild.getNodeName()) || propChild.getChildNodes() == null || propChild.getChildNodes().getLength() != 1 || !(propChild.getChildNodes().item(0) instanceof Text)) continue;
                        t = (Text)propChild.getChildNodes().item(0);
                        value = t.getTextContent();
                    }
                    if (key != null && value != null) {
                        LOG.debug("Loading configuration property: {}, {}", key, value);
                        this.config.setString(key, value);
                        continue;
                    }
                    LOG.warn("Error while reading configuration: Cannot read property " + propNumber);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cannot load configuration.", (Throwable)e);
        }
    }

    public static Configuration getConfiguration() {
        Configuration copy = new Configuration();
        copy.addAll(GlobalConfiguration.get().config);
        return copy;
    }

    public static void includeConfiguration(Configuration conf) {
        GlobalConfiguration.get().includeConfigurationInternal(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeConfigurationInternal(Configuration conf) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.config.addAll(conf);
        }
    }

    private static File[] filterFilesBySuffix(File dirToFilter, String suffix) {
        return GlobalConfiguration.filterFilesBySuffix(dirToFilter, new String[]{suffix});
    }

    private static File[] filterFilesBySuffix(final File dirToFilter, final String[] suffixes) {
        return dirToFilter.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String suffix : suffixes) {
                    if (!dir.equals(dirToFilter) || name == null || !name.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

