/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.Serializable;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.io.InputSplit;

@Public
public class GenericInputSplit
implements InputSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int partitionNumber;
    private final int totalNumberOfPartitions;

    public GenericInputSplit(int partitionNumber, int totalNumberOfPartitions) {
        this.partitionNumber = partitionNumber;
        this.totalNumberOfPartitions = totalNumberOfPartitions;
    }

    @Override
    public int getSplitNumber() {
        return this.partitionNumber;
    }

    public int getTotalNumberOfSplits() {
        return this.totalNumberOfPartitions;
    }

    public int hashCode() {
        return this.partitionNumber ^ this.totalNumberOfPartitions;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GenericInputSplit) {
            GenericInputSplit other = (GenericInputSplit)obj;
            return this.partitionNumber == other.partitionNumber && this.totalNumberOfPartitions == other.totalNumberOfPartitions;
        }
        return false;
    }

    public String toString() {
        return "GenericSplit (" + this.partitionNumber + '/' + this.totalNumberOfPartitions + ')';
    }
}

