/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public class MemorySegmentFactory {
    private static volatile Factory factory;

    public static MemorySegment wrap(byte[] buffer) {
        MemorySegmentFactory.ensureInitialized();
        return factory.wrap(buffer);
    }

    public static MemorySegment allocateUnpooledSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment(size, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size, Object owner) {
        MemorySegmentFactory.ensureInitialized();
        return factory.allocateUnpooledSegment(size, owner);
    }

    public static MemorySegment wrapPooledHeapMemory(byte[] memory, Object owner) {
        MemorySegmentFactory.ensureInitialized();
        return factory.wrapPooledHeapMemory(memory, owner);
    }

    public static MemorySegment wrapPooledOffHeapMemory(ByteBuffer memory, Object owner) {
        MemorySegmentFactory.ensureInitialized();
        return factory.wrapPooledOffHeapMemory(memory, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeFactory(Factory f) {
        if (f == null) {
            throw new NullPointerException();
        }
        Class<MemorySegmentFactory> clazz = MemorySegmentFactory.class;
        synchronized (MemorySegmentFactory.class) {
            if (factory != null) {
                throw new IllegalStateException("Factory has already been initialized");
            }
            factory = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isInitialized() {
        return factory != null;
    }

    public static Factory getFactory() {
        return factory;
    }

    private static void ensureInitialized() {
        if (factory == null) {
            factory = HeapMemorySegment.FACTORY;
        }
    }

    public static interface Factory {
        public MemorySegment wrap(byte[] var1);

        public MemorySegment allocateUnpooledSegment(int var1, Object var2);

        public MemorySegment wrapPooledHeapMemory(byte[] var1, Object var2);

        public MemorySegment wrapPooledOffHeapMemory(ByteBuffer var1, Object var2);
    }
}

