/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricRegistry;
import org.apache.flink.metrics.groups.ComponentMetricGroup;
import org.apache.flink.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.metrics.groups.scope.ScopeFormat;

@Internal
public class JobManagerMetricGroup
extends ComponentMetricGroup {
    private final Map<JobID, JobManagerJobMetricGroup> jobs = new HashMap<JobID, JobManagerJobMetricGroup>();
    private final String hostname;

    public JobManagerMetricGroup(MetricRegistry registry, String hostname) {
        this(registry, registry.getScopeFormats().getJobManagerFormat(), hostname);
    }

    public JobManagerMetricGroup(MetricRegistry registry, ScopeFormat.JobManagerScopeFormat scopeFormat, String hostname) {
        super(registry, scopeFormat.formatScope(hostname));
        this.hostname = hostname;
    }

    public String hostname() {
        return this.hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManagerJobMetricGroup addJob(JobID jobId, String jobName) {
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            if (!this.isClosed()) {
                JobManagerJobMetricGroup currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new JobManagerJobMetricGroup(this.registry, this, jobId, jobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
                return currentJobGroup;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobID jobId) {
        if (jobId == null) {
            return;
        }
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            JobManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null) {
                containedGroup.close();
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }
}

