/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.metrics.groups.TaskMetricGroup;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public abstract class ScopeFormat {
    private static CharacterFilter defaultFilter = new CharacterFilter(){

        @Override
        public String filterCharacters(String input) {
            return input;
        }
    };
    public static final String SCOPE_INHERIT_PARENT = "*";
    public static final String SCOPE_SEPARATOR = ".";
    private static final String SCOPE_VARIABLE_PREFIX = "<";
    private static final String SCOPE_VARIABLE_SUFFIX = ">";
    public static final String SCOPE_ACTOR_HOST = ScopeFormat.asVariable("host");
    public static final String DEFAULT_SCOPE_JOBMANAGER_COMPONENT;
    public static final String DEFAULT_SCOPE_JOBMANAGER_GROUP;
    public static final String SCOPE_TASKMANAGER_ID;
    public static final String DEFAULT_SCOPE_TASKMANAGER_COMPONENT;
    public static final String DEFAULT_SCOPE_TASKMANAGER_GROUP;
    public static final String SCOPE_JOB_ID;
    public static final String SCOPE_JOB_NAME;
    public static final String DEFAULT_SCOPE_JOB_COMPONENT;
    public static final String DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP;
    public static final String DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP;
    public static final String SCOPE_TASK_VERTEX_ID;
    public static final String SCOPE_TASK_NAME;
    public static final String SCOPE_TASK_ATTEMPT_ID;
    public static final String SCOPE_TASK_ATTEMPT_NUM;
    public static final String SCOPE_TASK_SUBTASK_INDEX;
    public static final String DEFAULT_SCOPE_TASK_COMPONENT;
    public static final String DEFAULT_SCOPE_TASK_GROUP;
    public static final String SCOPE_OPERATOR_NAME;
    public static final String DEFAULT_SCOPE_OPERATOR_COMPONENT;
    public static final String DEFAULT_SCOPE_OPERATOR_GROUP;
    private final String format;
    private final String[] template;
    private final int[] templatePos;
    private final int[] valuePos;

    protected ScopeFormat(String format, ScopeFormat parent, String[] variables) {
        boolean parentAsPrefix;
        Preconditions.checkNotNull(format, "format is null");
        String[] rawComponents = format.split("\\.");
        boolean bl = parentAsPrefix = rawComponents.length > 0 && rawComponents[0].equals(SCOPE_INHERIT_PARENT);
        if (parentAsPrefix) {
            if (parent == null) {
                throw new IllegalArgumentException("Component scope format requires parent prefix (starts with '*'), but this component has no parent (is root component).");
            }
            this.format = format.length() > 2 ? format.substring(2) : "<empty>";
            String[] parentTemplate = parent.template;
            int parentLen = parentTemplate.length;
            this.template = new String[parentLen + rawComponents.length - 1];
            System.arraycopy(parentTemplate, 0, this.template, 0, parentLen);
            System.arraycopy(rawComponents, 1, this.template, parentLen, rawComponents.length - 1);
        } else {
            this.format = format.isEmpty() ? "<empty>" : format;
            this.template = rawComponents;
        }
        HashMap<String, Integer> varToValuePos = ScopeFormat.arrayToMap(variables);
        ArrayList<Integer> templatePos = new ArrayList<Integer>();
        ArrayList<Integer> valuePos = new ArrayList<Integer>();
        for (int i = 0; i < this.template.length; ++i) {
            Integer replacementPos;
            String component = this.template[i];
            if (component == null || component.length() < 3 || component.charAt(0) != '<' || component.charAt(component.length() - 1) != '>' || (replacementPos = varToValuePos.get(component)) == null) continue;
            templatePos.add(i);
            valuePos.add(replacementPos);
        }
        this.templatePos = ScopeFormat.integerListToArray(templatePos);
        this.valuePos = ScopeFormat.integerListToArray(valuePos);
    }

    public String format() {
        return this.format;
    }

    protected final String[] copyTemplate() {
        String[] copy = new String[this.template.length];
        System.arraycopy(this.template, 0, copy, 0, this.template.length);
        return copy;
    }

    protected final String[] bindVariables(String[] template, String[] values) {
        int len = this.templatePos.length;
        for (int i = 0; i < len; ++i) {
            template[this.templatePos[i]] = values[this.valuePos[i]];
        }
        return template;
    }

    public String toString() {
        return "ScopeFormat '" + this.format + '\'';
    }

    public static String asVariable(String scope) {
        return SCOPE_VARIABLE_PREFIX + scope + SCOPE_VARIABLE_SUFFIX;
    }

    public static String concat(String ... components) {
        return ScopeFormat.concat(defaultFilter, Character.valueOf('.'), components);
    }

    public static String concat(CharacterFilter filter, String ... components) {
        return ScopeFormat.concat(filter, Character.valueOf('.'), components);
    }

    public static String concat(Character delimiter, String ... components) {
        return ScopeFormat.concat(defaultFilter, delimiter, components);
    }

    public static String concat(CharacterFilter filter, Character delimiter, String ... components) {
        StringBuilder sb = new StringBuilder();
        sb.append(filter.filterCharacters(components[0]));
        for (int x = 1; x < components.length; ++x) {
            sb.append(delimiter);
            sb.append(filter.filterCharacters(components[x]));
        }
        return sb.toString();
    }

    static String valueOrNull(Object value) {
        return value == null || value instanceof String && ((String)value).isEmpty() ? "null" : value.toString();
    }

    static HashMap<String, Integer> arrayToMap(String[] array) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            map.put(array[i], i);
        }
        return map;
    }

    private static int[] integerListToArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int pos = 0;
        for (Integer i : list) {
            array[pos++] = i;
        }
        return array;
    }

    static {
        DEFAULT_SCOPE_JOBMANAGER_GROUP = DEFAULT_SCOPE_JOBMANAGER_COMPONENT = ScopeFormat.concat(SCOPE_ACTOR_HOST, "jobmanager");
        SCOPE_TASKMANAGER_ID = ScopeFormat.asVariable("tm_id");
        DEFAULT_SCOPE_TASKMANAGER_GROUP = DEFAULT_SCOPE_TASKMANAGER_COMPONENT = ScopeFormat.concat(SCOPE_ACTOR_HOST, "taskmanager", SCOPE_TASKMANAGER_ID);
        SCOPE_JOB_ID = ScopeFormat.asVariable("job_id");
        DEFAULT_SCOPE_JOB_COMPONENT = SCOPE_JOB_NAME = ScopeFormat.asVariable("job_name");
        DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP = ScopeFormat.concat(DEFAULT_SCOPE_JOBMANAGER_COMPONENT, DEFAULT_SCOPE_JOB_COMPONENT);
        DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP = ScopeFormat.concat(DEFAULT_SCOPE_TASKMANAGER_COMPONENT, DEFAULT_SCOPE_JOB_COMPONENT);
        SCOPE_TASK_VERTEX_ID = ScopeFormat.asVariable("task_id");
        SCOPE_TASK_NAME = ScopeFormat.asVariable("task_name");
        SCOPE_TASK_ATTEMPT_ID = ScopeFormat.asVariable("task_attempt_id");
        SCOPE_TASK_ATTEMPT_NUM = ScopeFormat.asVariable("task_attempt_num");
        SCOPE_TASK_SUBTASK_INDEX = ScopeFormat.asVariable("subtask_index");
        DEFAULT_SCOPE_TASK_COMPONENT = ScopeFormat.concat(SCOPE_TASK_NAME, SCOPE_TASK_SUBTASK_INDEX);
        DEFAULT_SCOPE_TASK_GROUP = ScopeFormat.concat(DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP, DEFAULT_SCOPE_TASK_COMPONENT);
        SCOPE_OPERATOR_NAME = ScopeFormat.asVariable("operator_name");
        DEFAULT_SCOPE_OPERATOR_COMPONENT = ScopeFormat.concat(SCOPE_OPERATOR_NAME, SCOPE_TASK_SUBTASK_INDEX);
        DEFAULT_SCOPE_OPERATOR_GROUP = ScopeFormat.concat(DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP, DEFAULT_SCOPE_OPERATOR_COMPONENT);
    }

    public static class OperatorScopeFormat
    extends ScopeFormat {
        public OperatorScopeFormat(String format, TaskScopeFormat parentFormat) {
            super(format, parentFormat, new String[]{SCOPE_ACTOR_HOST, SCOPE_TASKMANAGER_ID, SCOPE_JOB_ID, SCOPE_JOB_NAME, SCOPE_TASK_VERTEX_ID, SCOPE_TASK_ATTEMPT_ID, SCOPE_TASK_NAME, SCOPE_TASK_SUBTASK_INDEX, SCOPE_TASK_ATTEMPT_NUM, SCOPE_OPERATOR_NAME});
        }

        public String[] formatScope(TaskMetricGroup parent, String operatorName) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{parent.parent().parent().hostname(), parent.parent().parent().taskManagerId(), OperatorScopeFormat.valueOrNull(parent.parent().jobId()), OperatorScopeFormat.valueOrNull(parent.parent().jobName()), OperatorScopeFormat.valueOrNull(parent.vertexId()), OperatorScopeFormat.valueOrNull(parent.executionId()), OperatorScopeFormat.valueOrNull(parent.taskName()), String.valueOf(parent.subtaskIndex()), String.valueOf(parent.attemptNumber()), OperatorScopeFormat.valueOrNull(operatorName)};
            return this.bindVariables(template, values);
        }
    }

    public static class TaskScopeFormat
    extends ScopeFormat {
        public TaskScopeFormat(String format, TaskManagerJobScopeFormat parentFormat) {
            super(format, parentFormat, new String[]{SCOPE_ACTOR_HOST, SCOPE_TASKMANAGER_ID, SCOPE_JOB_ID, SCOPE_JOB_NAME, SCOPE_TASK_VERTEX_ID, SCOPE_TASK_ATTEMPT_ID, SCOPE_TASK_NAME, SCOPE_TASK_SUBTASK_INDEX, SCOPE_TASK_ATTEMPT_NUM});
        }

        public String[] formatScope(TaskManagerJobMetricGroup parent, AbstractID vertexId, AbstractID attemptId, String taskName, int subtask, int attemptNumber) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{parent.parent().hostname(), parent.parent().taskManagerId(), TaskScopeFormat.valueOrNull(parent.jobId()), TaskScopeFormat.valueOrNull(parent.jobName()), TaskScopeFormat.valueOrNull(vertexId), TaskScopeFormat.valueOrNull(attemptId), TaskScopeFormat.valueOrNull(taskName), String.valueOf(subtask), String.valueOf(attemptNumber)};
            return this.bindVariables(template, values);
        }
    }

    public static class TaskManagerJobScopeFormat
    extends ScopeFormat {
        public TaskManagerJobScopeFormat(String format, TaskManagerScopeFormat parentFormat) {
            super(format, parentFormat, new String[]{SCOPE_ACTOR_HOST, SCOPE_TASKMANAGER_ID, SCOPE_JOB_ID, SCOPE_JOB_NAME});
        }

        public String[] formatScope(TaskManagerMetricGroup parent, JobID jid, String jobName) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{parent.hostname(), parent.taskManagerId(), TaskManagerJobScopeFormat.valueOrNull(jid), TaskManagerJobScopeFormat.valueOrNull(jobName)};
            return this.bindVariables(template, values);
        }
    }

    public static class JobManagerJobScopeFormat
    extends ScopeFormat {
        public JobManagerJobScopeFormat(String format, JobManagerScopeFormat parentFormat) {
            super(format, parentFormat, new String[]{SCOPE_ACTOR_HOST, SCOPE_JOB_ID, SCOPE_JOB_NAME});
        }

        public String[] formatScope(JobManagerMetricGroup parent, JobID jid, String jobName) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{parent.hostname(), JobManagerJobScopeFormat.valueOrNull(jid), JobManagerJobScopeFormat.valueOrNull(jobName)};
            return this.bindVariables(template, values);
        }
    }

    public static class TaskManagerScopeFormat
    extends ScopeFormat {
        public TaskManagerScopeFormat(String format) {
            super(format, null, new String[]{SCOPE_ACTOR_HOST, SCOPE_TASKMANAGER_ID});
        }

        public String[] formatScope(String hostname, String taskManagerId) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{hostname, taskManagerId};
            return this.bindVariables(template, values);
        }
    }

    public static class JobManagerScopeFormat
    extends ScopeFormat {
        public JobManagerScopeFormat(String format) {
            super(format, null, new String[]{SCOPE_ACTOR_HOST});
        }

        public String[] formatScope(String hostname) {
            String[] template = this.copyTemplate();
            String[] values = new String[]{hostname};
            return this.bindVariables(template, values);
        }
    }
}

