/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.reporter;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.groups.AbstractMetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JMXReporter
implements MetricReporter {
    private static final String PREFIX = "org.apache.flink.metrics:";
    private static final String KEY_PREFIX = "key";
    public static final String ARG_PORT = "port";
    private static final Logger LOG = LoggerFactory.getLogger(JMXReporter.class);
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final Map<Metric, ObjectName> registeredMetrics = new HashMap<Metric, ObjectName>();
    private JMXServer jmxServer;

    @Override
    public void open(Configuration config) {
        String portsConfig = config.getString(ARG_PORT, null);
        if (portsConfig != null) {
            Iterator<Integer> ports = NetUtils.getPortRangeFromString(portsConfig);
            JMXServer server = new JMXServer();
            while (ports.hasNext()) {
                int port = ports.next();
                try {
                    server.start(port);
                    LOG.info("Started JMX server on port " + port + ".");
                    this.jmxServer = server;
                    break;
                }
                catch (IOException ioe) {
                    LOG.debug("Could not start JMX server on port " + port + ".", (Throwable)ioe);
                    try {
                        server.stop();
                    }
                    catch (Exception e) {
                        LOG.debug("Could not stop JMX server.", (Throwable)e);
                    }
                }
            }
            if (this.jmxServer == null) {
                throw new RuntimeException("Could not start JMX server on any configured port. Ports: " + portsConfig);
            }
        }
    }

    @Override
    public void close() {
        if (this.jmxServer != null) {
            try {
                this.jmxServer.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop JMX server.", (Throwable)e);
            }
        }
    }

    public int getPort() {
        if (this.jmxServer == null) {
            throw new NullPointerException("No server was opened. Did you specify a port?");
        }
        return this.jmxServer.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfAddedMetric(Metric metric, String metricName, AbstractMetricGroup group) {
        AbstractBean jmxMetric;
        ObjectName jmxName;
        String name = JMXReporter.generateJmxName(metricName, group.getScopeComponents());
        try {
            jmxName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Metric name did not conform to JMX ObjectName rules: " + name, (Throwable)e);
            return;
        }
        if (metric instanceof Gauge) {
            jmxMetric = new JmxGauge((Gauge)metric);
        } else if (metric instanceof Counter) {
            jmxMetric = new JmxCounter((Counter)metric);
        } else if (metric instanceof Histogram) {
            jmxMetric = new JmxHistogram((Histogram)metric);
        } else {
            LOG.error("Cannot add unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
            return;
        }
        try {
            JMXReporter e = this;
            synchronized (e) {
                this.mBeanServer.registerMBean(jmxMetric, jmxName);
                this.registeredMetrics.put(metric, jmxName);
            }
        }
        catch (NotCompliantMBeanException e) {
            LOG.error("Metric did not comply with JMX MBean naming rules.", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.debug("A metric with the name " + jmxName + " was already registered.", (Throwable)e);
            LOG.error("A metric with the name " + jmxName + " was already registered.");
        }
        catch (Throwable t) {
            LOG.error("Failed to register metric", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfRemovedMetric(Metric metric, String metricName, AbstractMetricGroup group) {
        try {
            JMXReporter jMXReporter = this;
            synchronized (jMXReporter) {
                ObjectName jmxName = this.registeredMetrics.remove(metric);
                if (jmxName != null) {
                    this.mBeanServer.unregisterMBean(jmxName);
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable t) {
            LOG.error("Un-registering metric failed", t);
        }
    }

    static String generateJmxName(String metricName, String[] scopeComponents) {
        StringBuilder nameBuilder = new StringBuilder(128);
        nameBuilder.append(PREFIX);
        for (int x = 0; x < scopeComponents.length; ++x) {
            nameBuilder.append(KEY_PREFIX);
            nameBuilder.append(x);
            nameBuilder.append("=");
            nameBuilder.append(JMXReporter.replaceInvalidChars(scopeComponents[x]));
            nameBuilder.append(",");
        }
        nameBuilder.append("name=").append(JMXReporter.replaceInvalidChars(metricName));
        return nameBuilder.toString();
    }

    static String replaceInvalidChars(String str) {
        char[] chars = null;
        int strLen = str.length();
        int pos = 0;
        block5: for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    if (chars != null) continue block5;
                    chars = str.toCharArray();
                    continue block5;
                }
                case ' ': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 95;
                    continue block5;
                }
                case '\'': 
                case '*': 
                case ',': 
                case ':': 
                case ';': 
                case '=': 
                case '?': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 45;
                    continue block5;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? str : new String(chars, 0, pos);
    }

    private static class JMXServer {
        private Registry rmiRegistry;
        private JMXConnectorServer connector;
        private int port;

        private JMXServer() {
        }

        public void start(int port) throws IOException {
            if (this.rmiRegistry != null && this.connector != null) {
                LOG.debug("JMXServer is already running.");
                return;
            }
            this.startRmiRegistry(port);
            this.startJmxService(port);
            this.port = port;
        }

        private void startRmiRegistry(int port) throws IOException {
            this.rmiRegistry = LocateRegistry.createRegistry(port);
        }

        private void startJmxService(int port) throws IOException {
            JMXServiceURL url;
            String serviceUrl = "service:jmx:rmi://localhost:" + port + "/jndi/rmi://localhost:" + port + "/jmxrmi";
            try {
                url = new JMXServiceURL(serviceUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed service url created " + serviceUrl, e);
            }
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, ManagementFactory.getPlatformMBeanServer());
            this.connector.start();
        }

        public void stop() throws IOException {
            if (this.connector != null) {
                try {
                    this.connector.stop();
                }
                finally {
                    this.connector = null;
                }
            }
            if (this.rmiRegistry != null) {
                try {
                    UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
                }
                catch (NoSuchObjectException e) {
                    throw new IOException("Could not un-export our RMI registry", e);
                }
                finally {
                    this.rmiRegistry = null;
                }
            }
        }
    }

    private static class JmxHistogram
    extends AbstractBean
    implements JmxHistogramMBean {
        private final Histogram histogram;

        JmxHistogram(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public long getCount() {
            return this.histogram.getCount();
        }

        @Override
        public double getMean() {
            return this.histogram.getStatistics().getMean();
        }

        @Override
        public double getStdDev() {
            return this.histogram.getStatistics().getStdDev();
        }

        @Override
        public long getMax() {
            return this.histogram.getStatistics().getMax();
        }

        @Override
        public long getMin() {
            return this.histogram.getStatistics().getMin();
        }

        @Override
        public double getMedian() {
            return this.histogram.getStatistics().getQuantile(0.5);
        }

        @Override
        public double get75thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.75);
        }

        @Override
        public double get95thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.95);
        }

        @Override
        public double get98thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.98);
        }

        @Override
        public double get99thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.99);
        }

        @Override
        public double get999thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.999);
        }
    }

    public static interface JmxHistogramMBean
    extends MetricMBean {
        public long getCount();

        public double getMean();

        public double getStdDev();

        public long getMax();

        public long getMin();

        public double getMedian();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();
    }

    private static class JmxGauge
    extends AbstractBean
    implements JmxGaugeMBean {
        private final Gauge<?> gauge;

        JmxGauge(Gauge<?> gauge) {
            this.gauge = gauge;
        }

        @Override
        public Object getValue() {
            return this.gauge.getValue();
        }
    }

    public static interface JmxGaugeMBean
    extends MetricMBean {
        public Object getValue();
    }

    private static class JmxCounter
    extends AbstractBean
    implements JmxCounterMBean {
        private Counter counter;

        JmxCounter(Counter counter) {
            this.counter = counter;
        }

        @Override
        public long getCount() {
            return this.counter.getCount();
        }
    }

    public static interface JmxCounterMBean
    extends MetricMBean {
        public long getCount();
    }

    private static abstract class AbstractBean
    implements MetricMBean {
        private AbstractBean() {
        }
    }

    public static interface MetricMBean {
    }
}

