/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class ByteValueParser
extends FieldParser<ByteValue> {
    private ByteValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, ByteValue reusable) {
        int val = 0;
        boolean neg = false;
        this.result = reusable;
        int delimLimit = limit - delimiter.length + 1;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || startPos < delimLimit && ByteValueParser.delimiterNext(bytes, startPos, delimiter)) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (i < delimLimit && ByteValueParser.delimiterNext(bytes, i, delimiter)) {
                if (i == startPos) {
                    this.setErrorState(FieldParser.ParseErrorState.EMPTY_STRING);
                    return -1;
                }
                reusable.setValue((byte)(neg ? -val : val));
                return i + delimiter.length;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10;
            if ((val += bytes[i] - 48) <= 127 || neg && val <= 128) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        reusable.setValue((byte)(neg ? -val : val));
        return limit;
    }

    @Override
    public ByteValue createValue() {
        return new ByteValue();
    }

    @Override
    public ByteValue getLastResult() {
        return this.result;
    }
}

