/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class DoubleParser
extends FieldParser<Double> {
    private static final Double DOUBLE_INSTANCE = 0.0;
    private double result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Double reusable) {
        int i;
        int delimLimit = limit - delimiter.length + 1;
        for (i = startPos; !(i >= limit || i < delimLimit && DoubleParser.delimiterNext(bytes, i, delimiter)); ++i) {
        }
        if (i > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[i - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            this.result = Double.parseDouble(str);
            return i == limit ? limit : i + delimiter.length;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Double createValue() {
        return DOUBLE_INSTANCE;
    }

    @Override
    public Double getLastResult() {
        return this.result;
    }

    public static final double parseField(byte[] bytes, int startPos, int length) {
        return DoubleParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final double parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int i;
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        byte delByte = (byte)delimiter;
        for (i = 0; i < length && bytes[startPos + i] != delByte; ++i) {
        }
        if (i > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + i - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, i);
        return Double.parseDouble(str);
    }
}

