/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.BooleanParser;
import org.apache.flink.types.parser.BooleanValueParser;
import org.apache.flink.types.parser.ByteParser;
import org.apache.flink.types.parser.ByteValueParser;
import org.apache.flink.types.parser.DoubleParser;
import org.apache.flink.types.parser.DoubleValueParser;
import org.apache.flink.types.parser.FloatParser;
import org.apache.flink.types.parser.FloatValueParser;
import org.apache.flink.types.parser.IntParser;
import org.apache.flink.types.parser.IntValueParser;
import org.apache.flink.types.parser.LongParser;
import org.apache.flink.types.parser.LongValueParser;
import org.apache.flink.types.parser.ShortParser;
import org.apache.flink.types.parser.ShortValueParser;
import org.apache.flink.types.parser.StringParser;
import org.apache.flink.types.parser.StringValueParser;

@PublicEvolving
public abstract class FieldParser<T> {
    private ParseErrorState errorState = ParseErrorState.NONE;
    private static final Map<Class<?>, Class<? extends FieldParser<?>>> PARSERS = new HashMap();

    public int resetErrorStateAndParse(byte[] bytes, int startPos, int limit, byte[] delim, T reuse) {
        this.resetParserState();
        return this.parseField(bytes, startPos, limit, delim, reuse);
    }

    protected abstract int parseField(byte[] var1, int var2, int var3, byte[] var4, T var5);

    protected void resetParserState() {
        this.errorState = ParseErrorState.NONE;
    }

    public abstract T getLastResult();

    public abstract T createValue();

    public static final boolean delimiterNext(byte[] bytes, int startPos, byte[] delim) {
        for (int pos = 0; pos < delim.length; ++pos) {
            if (delim[pos] == bytes[startPos + pos]) continue;
            return false;
        }
        return true;
    }

    protected void setErrorState(ParseErrorState error) {
        this.errorState = error;
    }

    public ParseErrorState getErrorState() {
        return this.errorState;
    }

    public static <T> Class<FieldParser<T>> getParserForType(Class<T> type) {
        Class<FieldParser<T>> parser = PARSERS.get(type);
        if (parser == null) {
            return null;
        }
        Class<FieldParser<T>> typedParser = parser;
        return typedParser;
    }

    static {
        PARSERS.put(Byte.class, ByteParser.class);
        PARSERS.put(Short.class, ShortParser.class);
        PARSERS.put(Integer.class, IntParser.class);
        PARSERS.put(Long.class, LongParser.class);
        PARSERS.put(String.class, StringParser.class);
        PARSERS.put(Float.class, FloatParser.class);
        PARSERS.put(Double.class, DoubleParser.class);
        PARSERS.put(Boolean.class, BooleanParser.class);
        PARSERS.put(ByteValue.class, ByteValueParser.class);
        PARSERS.put(ShortValue.class, ShortValueParser.class);
        PARSERS.put(IntValue.class, IntValueParser.class);
        PARSERS.put(LongValue.class, LongValueParser.class);
        PARSERS.put(StringValue.class, StringValueParser.class);
        PARSERS.put(FloatValue.class, FloatValueParser.class);
        PARSERS.put(DoubleValue.class, DoubleValueParser.class);
        PARSERS.put(BooleanValue.class, BooleanValueParser.class);
    }

    public static enum ParseErrorState {
        NONE,
        NUMERIC_VALUE_OVERFLOW_UNDERFLOW,
        NUMERIC_VALUE_ORPHAN_SIGN,
        NUMERIC_VALUE_ILLEGAL_CHARACTER,
        NUMERIC_VALUE_FORMAT_ERROR,
        UNTERMINATED_QUOTED_STRING,
        UNQUOTED_CHARS_AFTER_QUOTED_STRING,
        EMPTY_STRING,
        BOOLEAN_INVALID;

    }
}

