/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class FloatParser
extends FieldParser<Float> {
    private float result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Float reusable) {
        int i;
        int delimLimit = limit - delimiter.length + 1;
        for (i = startPos; !(i >= limit || i < delimLimit && FloatParser.delimiterNext(bytes, i, delimiter)); ++i) {
        }
        if (i > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[i - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            this.result = Float.parseFloat(str);
            return i == limit ? limit : i + delimiter.length;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Float createValue() {
        return Float.valueOf(Float.MIN_VALUE);
    }

    @Override
    public Float getLastResult() {
        return Float.valueOf(this.result);
    }

    public static final float parseField(byte[] bytes, int startPos, int length) {
        return FloatParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final float parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int i;
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        byte delByte = (byte)delimiter;
        for (i = 0; i < length && bytes[startPos + i] != delByte; ++i) {
        }
        if (i > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + i - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, i);
        return Float.parseFloat(str);
    }
}

