/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class LongParser
extends FieldParser<Long> {
    private long result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Long reusable) {
        long val = 0L;
        boolean neg = false;
        int delimLimit = limit - delimiter.length + 1;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || startPos < delimLimit && LongParser.delimiterNext(bytes, startPos, delimiter)) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (i < delimLimit && LongParser.delimiterNext(bytes, i, delimiter)) {
                if (i == startPos) {
                    this.setErrorState(FieldParser.ParseErrorState.EMPTY_STRING);
                    return -1;
                }
                this.result = neg ? -val : val;
                return i + delimiter.length;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10L;
            if ((val += (long)(bytes[i] - 48)) >= 0L) continue;
            if (neg && val == Long.MIN_VALUE) {
                this.result = Long.MIN_VALUE;
                if (i + 1 >= limit) {
                    return limit;
                }
                if (i + 1 < delimLimit && LongParser.delimiterNext(bytes, i + 1, delimiter)) {
                    return i + 1 + delimiter.length;
                }
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
                return -1;
            }
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        this.result = neg ? -val : val;
        return limit;
    }

    @Override
    public Long createValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public Long getLastResult() {
        return this.result;
    }

    public static final long parseField(byte[] bytes, int startPos, int length) {
        return LongParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final long parseField(byte[] bytes, int startPos, int length, char delimiter) {
        long val = 0L;
        boolean neg = false;
        if (bytes[startPos] == delimiter) {
            throw new NumberFormatException("Empty field.");
        }
        if (bytes[startPos] == 45) {
            neg = true;
            if (--length == 0 || bytes[++startPos] == delimiter) {
                throw new NumberFormatException("Orphaned minus sign.");
            }
        }
        while (length > 0) {
            if (bytes[startPos] == delimiter) {
                return neg ? -val : val;
            }
            if (bytes[startPos] < 48 || bytes[startPos] > 57) {
                throw new NumberFormatException("Invalid character.");
            }
            val *= 10L;
            if ((val += (long)(bytes[startPos] - 48)) < 0L) {
                if (neg && val == Long.MIN_VALUE) {
                    if (length == 1 || bytes[startPos + 1] == delimiter) {
                        return Long.MIN_VALUE;
                    }
                    throw new NumberFormatException("value overflow");
                }
                throw new NumberFormatException("value overflow");
            }
            ++startPos;
            --length;
        }
        return neg ? -val : val;
    }
}

