/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class StringParser
extends FieldParser<String> {
    private boolean quotedStringParsing = false;
    private byte quoteCharacter;
    private static final byte BACKSLASH = 92;
    private String result;

    public void enableQuotedStringParsing(byte quoteCharacter) {
        this.quotedStringParsing = true;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, String reusable) {
        int i;
        int delimLimit = limit - delimiter.length + 1;
        if (this.quotedStringParsing && bytes[i] == this.quoteCharacter) {
            ++i;
            while (i < limit && (bytes[i] != this.quoteCharacter || bytes[i - 1] == 92)) {
                ++i;
            }
            if (i == limit) {
                this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
                return -1;
            }
            if (++i == limit) {
                this.result = new String(bytes, startPos + 1, i - startPos - 2);
                return limit;
            }
            if (i < delimLimit && StringParser.delimiterNext(bytes, i, delimiter)) {
                this.result = new String(bytes, startPos + 1, i - startPos - 2);
                return i + delimiter.length;
            }
            this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
            return -1;
        }
        for (i = startPos; i < delimLimit && !StringParser.delimiterNext(bytes, i, delimiter); ++i) {
        }
        if (i >= delimLimit) {
            this.result = new String(bytes, startPos, limit - startPos);
            return limit;
        }
        this.result = new String(bytes, startPos, i - startPos);
        return i + delimiter.length;
    }

    @Override
    public String createValue() {
        return "";
    }

    @Override
    public String getLastResult() {
        return this.result;
    }
}

