/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public final class FileUtils {
    private static final char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int LENGTH = 12;

    public static String getRandomFilename(String prefix) {
        StringBuilder stringBuilder = new StringBuilder(prefix);
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(ALPHABET[(int)Math.floor(Math.random() * (double)ALPHABET.length)]);
        }
        return stringBuilder.toString();
    }

    public static String readFile(File file, String charsetName) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, charsetName);
    }

    public static String readFileUtf8(File file) throws IOException {
        return FileUtils.readFile(file, "UTF-8");
    }

    public static void writeFile(File file, String contents, String encoding) throws IOException {
        byte[] bytes = contents.getBytes(encoding);
        Files.write(file.toPath(), bytes, StandardOpenOption.WRITE);
    }

    public static void writeFileUtf8(File file, String contents) throws IOException {
        FileUtils.writeFile(file, contents, "UTF-8");
    }

    private FileUtils() {
    }
}

