/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.UnionIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);

    public static String getHostnameFromFQDN(String fqdn) {
        if (fqdn == null) {
            throw new IllegalArgumentException("fqdn is null");
        }
        int dotPos = fqdn.indexOf(46);
        if (dotPos == -1) {
            return fqdn;
        }
        return fqdn.substring(0, dotPos);
    }

    public static URL getCorrectHostnamePort(String hostPort) {
        try {
            URL u = new URL("http://" + hostPort);
            if (u.getHost() == null) {
                throw new IllegalArgumentException("The given host:port ('" + hostPort + "') doesn't contain a valid host");
            }
            if (u.getPort() == -1) {
                throw new IllegalArgumentException("The given host:port ('" + hostPort + "') doesn't contain a valid port");
            }
            return u;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The given host:port ('" + hostPort + "') is invalid", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort() {
        int i = 0;
        while (i < 50) {
            try (ServerSocket serverSocket = new ServerSocket(0);){
                int port = serverSocket.getLocalPort();
                if (port != 0) {
                    int n = port;
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        throw new RuntimeException("Could not find a free permitted port on the machine.");
    }

    public static String ipAddressToUrlString(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (address instanceof Inet4Address) {
            return address.getHostAddress();
        }
        if (address instanceof Inet6Address) {
            return NetUtils.getIPv6UrlRepresentation((Inet6Address)address);
        }
        throw new IllegalArgumentException("Unrecognized type of InetAddress: " + address);
    }

    public static String ipAddressAndPortToUrlString(InetAddress address, int port) {
        return NetUtils.ipAddressToUrlString(address) + ':' + port;
    }

    public static String socketAddressToUrlString(InetSocketAddress address) {
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Address cannot be resolved: " + address.getHostString());
        }
        return NetUtils.ipAddressAndPortToUrlString(address.getAddress(), address.getPort());
    }

    public static String hostAndPortToUrlString(String host, int port) throws UnknownHostException {
        return NetUtils.ipAddressAndPortToUrlString(InetAddress.getByName(host), port);
    }

    private static String getIPv6UrlRepresentation(Inet6Address address) {
        byte[] addressBytes = address.getAddress();
        int[] hextets = new int[8];
        for (int i = 0; i < hextets.length; ++i) {
            hextets[i] = (addressBytes[2 * i] & 0xFF) << 8 | addressBytes[2 * i + 1] & 0xFF;
        }
        int bestRunStart = -1;
        int bestRunLength = -1;
        int runStart = -1;
        for (int i = 0; i < hextets.length + 1; ++i) {
            if (i < hextets.length && hextets[i] == 0) {
                if (runStart >= 0) continue;
                runStart = i;
                continue;
            }
            if (runStart < 0) continue;
            int runLength = i - runStart;
            if (runLength > bestRunLength) {
                bestRunStart = runStart;
                bestRunLength = runLength;
            }
            runStart = -1;
        }
        if (bestRunLength >= 2) {
            Arrays.fill(hextets, bestRunStart, bestRunStart + bestRunLength, -1);
        }
        StringBuilder buf = new StringBuilder(40);
        buf.append('[');
        boolean lastWasNumber = false;
        for (int i = 0; i < hextets.length; ++i) {
            boolean thisIsNumber;
            boolean bl = thisIsNumber = hextets[i] >= 0;
            if (thisIsNumber) {
                if (lastWasNumber) {
                    buf.append(':');
                }
                buf.append(Integer.toHexString(hextets[i]));
            } else if (i == 0 || lastWasNumber) {
                buf.append("::");
            }
            lastWasNumber = thisIsNumber;
        }
        buf.append(']');
        return buf.toString();
    }

    public static Iterator<Integer> getPortRangeFromString(String rangeDefinition) throws NumberFormatException {
        String[] ranges = rangeDefinition.trim().split(",");
        UnionIterator<Integer> iterators = new UnionIterator<Integer>();
        for (String rawRange : ranges) {
            Iterator<Integer> rangeIterator;
            String range = rawRange.trim();
            int dashIdx = range.indexOf(45);
            if (dashIdx == -1) {
                rangeIterator = Collections.singleton(Integer.valueOf(range)).iterator();
            } else {
                final int start = Integer.valueOf(range.substring(0, dashIdx));
                final int end = Integer.valueOf(range.substring(dashIdx + 1, range.length()));
                rangeIterator = new Iterator<Integer>(){
                    int i;
                    {
                        this.i = start;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i <= end;
                    }

                    @Override
                    public Integer next() {
                        return this.i++;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }
            iterators.add(rangeIterator);
        }
        return iterators;
    }

    public static ServerSocket createSocketFromPorts(Iterator<Integer> portsIterator, SocketFactory factory) {
        while (portsIterator.hasNext()) {
            int port = portsIterator.next();
            LOG.debug("Trying to open socket on port {}", (Object)port);
            try {
                return factory.createSocket(port);
            }
            catch (IOException | IllegalArgumentException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to allocate socket on port", (Throwable)e);
                    continue;
                }
                LOG.info("Unable to allocate on port {}, due to error: {}", (Object)port, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static interface SocketFactory {
        public ServerSocket createSocket(int var1) throws IOException;
    }
}

