/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Properties;
import org.slf4j.Logger;

public class PropertiesUtil {
    public static int getInt(Properties config, String key, int defaultValue) {
        String val = config.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. " + "Entered value='" + val + "'. Default value='" + defaultValue + "'");
        }
    }

    public static long getLong(Properties config, String key, long defaultValue) {
        String val = config.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. " + "Entered value='" + val + "'. Default value='" + defaultValue + "'");
        }
    }

    public static long getLong(Properties config, String key, long defaultValue, Logger logger) {
        try {
            return PropertiesUtil.getLong(config, key, defaultValue);
        }
        catch (IllegalArgumentException iae) {
            logger.warn(iae.getMessage());
            return defaultValue;
        }
    }

    private PropertiesUtil() {
    }
}

