/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionConfigTest
extends TestLogger {
    @Test
    public void testDoubleTypeRegistration() {
        ExecutionConfig config = new ExecutionConfig();
        List<Class> types = Arrays.asList(Double.class, Integer.class, Double.class);
        List<Class> expectedTypes = Arrays.asList(Double.class, Integer.class);
        for (Class tpe : types) {
            config.registerKryoType(tpe);
        }
        int counter = 0;
        for (Class tpe : config.getRegisteredKryoTypes()) {
            Assert.assertEquals((Object)tpe, (Object)expectedTypes.get(counter++));
        }
        Assert.assertEquals((long)expectedTypes.size(), (long)counter);
    }

    @Test
    public void testConfigurationOfParallelism() {
        ExecutionConfig config = new ExecutionConfig();
        int parallelism = 36;
        config.setParallelism(parallelism);
        Assert.assertEquals((long)parallelism, (long)config.getParallelism());
        parallelism = -1;
        config.setParallelism(parallelism);
        Assert.assertEquals((long)parallelism, (long)config.getParallelism());
    }

    @Test
    public void testDisableGenericTypes() {
        ExecutionConfig conf = new ExecutionConfig();
        GenericTypeInfo typeInfo = new GenericTypeInfo(Object.class);
        TypeSerializer serializer = typeInfo.createSerializer(conf);
        Assert.assertTrue((boolean)(serializer instanceof KryoSerializer));
        conf.disableGenericTypes();
        try {
            typeInfo.createSerializer(conf);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testExecutionConfigSerialization() throws IOException, ClassNotFoundException {
        Random r = new Random();
        int parallelism = 1 + r.nextInt(10);
        boolean closureCleanerEnabled = r.nextBoolean();
        boolean forceAvroEnabled = r.nextBoolean();
        boolean forceKryoEnabled = r.nextBoolean();
        boolean disableGenericTypes = r.nextBoolean();
        boolean objectReuseEnabled = r.nextBoolean();
        ExecutionConfig config = new ExecutionConfig();
        if (closureCleanerEnabled) {
            config.enableClosureCleaner();
        } else {
            config.disableClosureCleaner();
        }
        if (forceAvroEnabled) {
            config.enableForceAvro();
        } else {
            config.disableForceAvro();
        }
        if (forceKryoEnabled) {
            config.enableForceKryo();
        } else {
            config.disableForceKryo();
        }
        if (disableGenericTypes) {
            config.disableGenericTypes();
        } else {
            config.enableGenericTypes();
        }
        if (objectReuseEnabled) {
            config.enableObjectReuse();
        } else {
            config.disableObjectReuse();
        }
        config.setParallelism(parallelism);
        ExecutionConfig copy1 = (ExecutionConfig)CommonTestUtils.createCopySerializable((Serializable)config);
        ExecutionConfig copy2 = (ExecutionConfig)new SerializedValue((Object)config).deserializeValue(((Object)((Object)this)).getClass().getClassLoader());
        Assert.assertNotNull((Object)copy1);
        Assert.assertNotNull((Object)copy2);
        Assert.assertEquals((Object)config, (Object)copy1);
        Assert.assertEquals((Object)config, (Object)copy2);
        Assert.assertEquals((Object)closureCleanerEnabled, (Object)copy1.isClosureCleanerEnabled());
        Assert.assertEquals((Object)forceAvroEnabled, (Object)copy1.isForceAvroEnabled());
        Assert.assertEquals((Object)forceKryoEnabled, (Object)copy1.isForceKryoEnabled());
        Assert.assertEquals((Object)disableGenericTypes, (Object)copy1.hasGenericTypesDisabled());
        Assert.assertEquals((Object)objectReuseEnabled, (Object)copy1.isObjectReuseEnabled());
        Assert.assertEquals((long)parallelism, (long)copy1.getParallelism());
    }

    @Test
    public void testGlobalParametersNotNull() {
        ExecutionConfig config = new ExecutionConfig();
        Assert.assertNotNull((Object)config.getGlobalJobParameters());
    }

    @Test
    public void testGlobalParametersHashCode() {
        ExecutionConfig config = new ExecutionConfig();
        ExecutionConfig anotherConfig = new ExecutionConfig();
        Assert.assertEquals((long)config.getGlobalJobParameters().hashCode(), (long)anotherConfig.getGlobalJobParameters().hashCode());
    }

    @Test
    public void testReadingDefaultConfig() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        Configuration configuration = new Configuration();
        executionConfig.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        Assert.assertThat((Object)executionConfig, (Matcher)CoreMatchers.equalTo((Object)new ExecutionConfig()));
    }

    @Test
    public void testLoadingRegisteredKryoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.registerKryoType(ExecutionConfigTest.class);
        configFromSetters.registerKryoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-kryo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)configFromConfiguration, (Matcher)CoreMatchers.equalTo((Object)configFromSetters));
    }

    @Test
    public void testLoadingRegisteredPojoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.registerPojoType(ExecutionConfigTest.class);
        configFromSetters.registerPojoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-pojo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)configFromConfiguration, (Matcher)CoreMatchers.equalTo((Object)configFromSetters));
    }

    @Test
    public void testLoadingRestartStrategyFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)10, (Time)Time.minutes((long)2L)));
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("restart-strategy", "fixeddelay");
        configuration.setString("restart-strategy.fixed-delay.attempts", "10");
        configuration.setString("restart-strategy.fixed-delay.delay", "2 min");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)configFromConfiguration, (Matcher)CoreMatchers.equalTo((Object)configFromSetters));
    }

    @Test
    public void testLoadingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        configFromSetters.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.default-kryo-serializers", "class:org.apache.flink.api.common.ExecutionConfigTest,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1;class:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer2");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)configFromConfiguration, (Matcher)CoreMatchers.equalTo((Object)configFromSetters));
    }

    @Test
    public void testLoadingIsDynamicGraphFromConfiguration() {
        this.testLoadingIsDynamicGraphFromConfiguration(JobManagerOptions.SchedulerType.AdaptiveBatch, true);
        this.testLoadingIsDynamicGraphFromConfiguration(JobManagerOptions.SchedulerType.Default, false);
        this.testLoadingIsDynamicGraphFromConfiguration(JobManagerOptions.SchedulerType.Adaptive, false);
    }

    private void testLoadingIsDynamicGraphFromConfiguration(JobManagerOptions.SchedulerType schedulerType, boolean expectIsDynamicGraph) {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)schedulerType);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)configFromConfiguration.isDynamicGraph(), (Matcher)CoreMatchers.is((Object)expectIsDynamicGraph));
    }

    @Test
    public void testNotOverridingRegisteredKryoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.registerKryoType(ExecutionConfigTest.class);
        config.registerKryoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assert.assertThat((Object)config.getRegisteredKryoTypes(), (Matcher)CoreMatchers.equalTo(set));
    }

    @Test
    public void testNotOverridingRegisteredPojoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.registerPojoType(ExecutionConfigTest.class);
        config.registerPojoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assert.assertThat((Object)config.getRegisteredPojoTypes(), (Matcher)CoreMatchers.equalTo(set));
    }

    @Test
    public void testNotOverridingRestartStrategiesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = RestartStrategies.fixedDelayRestart((int)10, (Time)Time.minutes((long)2L));
        config.setRestartStrategy(restartStrategyConfiguration);
        config.configure((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader());
        Assert.assertThat((Object)config.getRestartStrategy(), (Matcher)CoreMatchers.equalTo((Object)restartStrategyConfiguration));
    }

    @Test
    public void testNotOverridingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        config.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashMap<Class, Class> serialiers = new LinkedHashMap<Class, Class>();
        serialiers.put(ExecutionConfigTest.class, TestSerializer1.class);
        serialiers.put(TestSerializer1.class, TestSerializer2.class);
        Assert.assertThat((Object)config.getDefaultKryoSerializerClasses(), (Matcher)CoreMatchers.equalTo(serialiers));
    }

    private static class TestSerializer2
    extends Serializer<TestSerializer1>
    implements Serializable {
        private TestSerializer2() {
        }

        public void write(Kryo kryo, Output output, TestSerializer1 object) {
        }

        public TestSerializer1 read(Kryo kryo, Input input, Class<TestSerializer1> type) {
            return null;
        }
    }

    private static class TestSerializer1
    extends Serializer<ExecutionConfigTest>
    implements Serializable {
        private TestSerializer1() {
        }

        public void write(Kryo kryo, Output output, ExecutionConfigTest object) {
        }

        public ExecutionConfigTest read(Kryo kryo, Input input, Class<ExecutionConfigTest> type) {
            return null;
        }
    }
}

