/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AverageAccumulator;
import org.junit.Assert;
import org.junit.Test;

public class AverageAccumulatorTest {
    @Test
    public void testGet() {
        AverageAccumulator average = new AverageAccumulator();
        Assert.assertEquals((double)0.0, (double)average.getLocalValue(), (double)0.0);
    }

    @Test
    public void testAdd() {
        AverageAccumulator average = new AverageAccumulator();
        for (int i1 = 0; i1 < 10; ++i1) {
            average.add(i1);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        Integer i2 = 0;
        while (i2 < 10) {
            average.add(i2.intValue());
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        for (long i3 = 0L; i3 < 10L; ++i3) {
            average.add(i3);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        Long i4 = 0L;
        while (i4 < 10L) {
            average.add(i4.longValue());
            Long l = i4;
            Long l2 = i4 = Long.valueOf(i4 + 1L);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        for (double i5 = 0.0; i5 < 10.0; i5 += 1.0) {
            average.add(i5);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        Double i6 = 0.0;
        while (i6 < 10.0) {
            average.add(i6);
            Double d = i6;
            Double d2 = i6 = Double.valueOf(i6 + 1.0);
        }
        Assert.assertEquals((double)4.5, (double)average.getLocalValue(), (double)0.0);
        average.resetLocal();
        Assert.assertEquals((double)0.0, (double)average.getLocalValue(), (double)0.0);
    }

    @Test
    public void testMergeSuccess() {
        AverageAccumulator avg1 = new AverageAccumulator();
        for (int i = 0; i < 5; ++i) {
            avg1.add(i);
        }
        AverageAccumulator avg2 = new AverageAccumulator();
        for (int i = 5; i < 10; ++i) {
            avg2.add(i);
        }
        avg1.merge((Accumulator)avg2);
        Assert.assertEquals((double)4.5, (double)avg1.getLocalValue(), (double)0.0);
    }

    @Test
    public void testMergeFailed() {
        AverageAccumulator average = new AverageAccumulator();
        Accumulator averageNew = null;
        average.add(1);
        try {
            average.merge(averageNew);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("The merged accumulator must be AverageAccumulator."));
        }
        catch (Throwable t) {
            Assert.fail((String)("wrong exception; expected IllegalArgumentException but found " + t.getClass().getName()));
        }
    }

    @Test
    public void testClone() {
        AverageAccumulator average = new AverageAccumulator();
        average.add(1);
        AverageAccumulator averageNew = average.clone();
        Assert.assertEquals((double)1.0, (double)averageNew.getLocalValue(), (double)0.0);
    }
}

