/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntMaximum;
import org.junit.Assert;
import org.junit.Test;

public class IntMaximumTest {
    @Test
    public void testGet() {
        IntMaximum max = new IntMaximum();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)max.getLocalValue().intValue());
    }

    @Test
    public void testResetLocal() {
        IntMaximum max = new IntMaximum();
        int value = 13;
        max.add(value);
        Assert.assertEquals((long)value, (long)max.getLocalValue().intValue());
        max.resetLocal();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)max.getLocalValue().intValue());
    }

    @Test
    public void testAdd() {
        IntMaximum max = new IntMaximum();
        max.add(1234);
        max.add(9876);
        max.add(-987);
        max.add(-123);
        Assert.assertEquals((long)9876L, (long)max.getLocalValue().intValue());
    }

    @Test
    public void testMerge() {
        IntMaximum max1 = new IntMaximum();
        max1.add(1234);
        IntMaximum max2 = new IntMaximum();
        max2.add(5678);
        max2.merge((Accumulator)max1);
        Assert.assertEquals((long)5678L, (long)max2.getLocalValue().intValue());
        max1.merge((Accumulator)max2);
        Assert.assertEquals((long)5678L, (long)max1.getLocalValue().intValue());
    }

    @Test
    public void testClone() {
        IntMaximum max = new IntMaximum();
        int value = 42;
        max.add(value);
        IntMaximum clone = max.clone();
        Assert.assertEquals((long)value, (long)clone.getLocalValue().intValue());
    }
}

