/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntMinimum;
import org.junit.Assert;
import org.junit.Test;

public class IntMinimumTest {
    @Test
    public void testGet() {
        IntMinimum min = new IntMinimum();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)min.getLocalValue().intValue());
    }

    @Test
    public void testResetLocal() {
        IntMinimum min = new IntMinimum();
        int value = 13;
        min.add(value);
        Assert.assertEquals((long)value, (long)min.getLocalValue().intValue());
        min.resetLocal();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)min.getLocalValue().intValue());
    }

    @Test
    public void testAdd() {
        IntMinimum min = new IntMinimum();
        min.add(1234);
        min.add(9876);
        min.add(-987);
        min.add(-123);
        Assert.assertEquals((long)-987L, (long)min.getLocalValue().intValue());
    }

    @Test
    public void testMerge() {
        IntMinimum min1 = new IntMinimum();
        min1.add(1234);
        IntMinimum min2 = new IntMinimum();
        min2.add(5678);
        min2.merge((Accumulator)min1);
        Assert.assertEquals((long)1234L, (long)min2.getLocalValue().intValue());
        min1.merge((Accumulator)min2);
        Assert.assertEquals((long)1234L, (long)min1.getLocalValue().intValue());
    }

    @Test
    public void testClone() {
        IntMinimum min = new IntMinimum();
        int value = 42;
        min.add(value);
        IntMinimum clone = min.clone();
        Assert.assertEquals((long)value, (long)clone.getLocalValue().intValue());
    }
}

