/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.time.Duration;
import org.apache.flink.api.common.eventtime.BoundedOutOfOrdernessWatermarks;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.junit.Assert;
import org.junit.Test;

public class BoundedOutOfOrdernessWatermarksTest {
    @Test
    public void testWatermarkBeforeRecords() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertNotNull((Object)output.lastWatermark());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)output.lastWatermark().getTimestamp());
    }

    @Test
    public void testWatermarkAfterEvent() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 1337L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)1326L, (long)output.lastWatermark().getTimestamp());
    }

    @Test
    public void testWatermarkAfterNonMonotonousEvents() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 12345L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12300L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12340L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12280L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)12334L, (long)output.lastWatermark().getTimestamp());
    }

    @Test
    public void testRepeatedProbe() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 723456L, (WatermarkOutput)new TestingWatermarkOutput());
        watermarks.onPeriodicEmit((WatermarkOutput)new TestingWatermarkOutput());
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)723445L, (long)output.lastWatermark().getTimestamp());
    }
}

