/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.junit.Assert;
import org.junit.Test;

public class RuntimeUDFContextTest {
    private final TaskInfo taskInfo = new TaskInfo("test name", 3, 1, 3, 0);

    @Test
    public void testBroadcastVariableNotFound() {
        try {
            RuntimeUDFContext ctx = new RuntimeUDFContext(this.taskInfo, this.getClass().getClassLoader(), new ExecutionConfig(), new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup());
            Assert.assertFalse((boolean)ctx.hasBroadcastVariable("some name"));
            try {
                ctx.getBroadcastVariable("some name");
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                ctx.getBroadcastVariableWithInitializer("some name", (BroadcastVariableInitializer)new BroadcastVariableInitializer<Object, Object>(){

                    public Object initializeBroadcastVariable(Iterable<Object> data) {
                        return null;
                    }
                });
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBroadcastVariableSimple() {
        try {
            RuntimeUDFContext ctx = new RuntimeUDFContext(this.taskInfo, this.getClass().getClassLoader(), new ExecutionConfig(), new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup());
            ctx.setBroadcastVariable("name1", Arrays.asList(1, 2, 3, 4));
            ctx.setBroadcastVariable("name2", Arrays.asList(1.0, 2.0, 3.0, 4.0));
            Assert.assertTrue((boolean)ctx.hasBroadcastVariable("name1"));
            Assert.assertTrue((boolean)ctx.hasBroadcastVariable("name2"));
            List list1 = ctx.getBroadcastVariable("name1");
            List list2 = ctx.getBroadcastVariable("name2");
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)list1);
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list2);
            List list3 = ctx.getBroadcastVariable("name1");
            List list4 = ctx.getBroadcastVariable("name2");
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)list3);
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list4);
            List list5 = ctx.getBroadcastVariable("name1");
            List list6 = ctx.getBroadcastVariable("name2");
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)list5);
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list6);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBroadcastVariableWithInitializer() {
        try {
            RuntimeUDFContext ctx = new RuntimeUDFContext(this.taskInfo, this.getClass().getClassLoader(), new ExecutionConfig(), new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup());
            ctx.setBroadcastVariable("name", Arrays.asList(1, 2, 3, 4));
            List list = (List)ctx.getBroadcastVariableWithInitializer("name", (BroadcastVariableInitializer)new ConvertingInitializer());
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list);
            List list2 = (List)ctx.getBroadcastVariableWithInitializer("name", (BroadcastVariableInitializer)new ConvertingInitializer());
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list2);
            List list3 = ctx.getBroadcastVariable("name");
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list3);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testResetBroadcastVariableWithInitializer() {
        try {
            RuntimeUDFContext ctx = new RuntimeUDFContext(this.taskInfo, this.getClass().getClassLoader(), new ExecutionConfig(), new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup());
            ctx.setBroadcastVariable("name", Arrays.asList(1, 2, 3, 4));
            List list = (List)ctx.getBroadcastVariableWithInitializer("name", (BroadcastVariableInitializer)new ConvertingInitializer());
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0), (Object)list);
            ctx.setBroadcastVariable("name", Arrays.asList(2, 3, 4, 5));
            List list2 = (List)ctx.getBroadcastVariableWithInitializer("name", (BroadcastVariableInitializer)new ConvertingInitializer());
            Assert.assertEquals(Arrays.asList(2.0, 3.0, 4.0, 5.0), (Object)list2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBroadcastVariableWithInitializerAndMismatch() {
        try {
            RuntimeUDFContext ctx = new RuntimeUDFContext(this.taskInfo, this.getClass().getClassLoader(), new ExecutionConfig(), new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup());
            ctx.setBroadcastVariable("name", Arrays.asList(1, 2, 3, 4));
            int sum = (Integer)ctx.getBroadcastVariableWithInitializer("name", (BroadcastVariableInitializer)new SumInitializer());
            Assert.assertEquals((long)10L, (long)sum);
            try {
                ctx.getBroadcastVariable("name");
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static final class SumInitializer
    implements BroadcastVariableInitializer<Integer, Integer> {
        private SumInitializer() {
        }

        public Integer initializeBroadcastVariable(Iterable<Integer> data) {
            int sum = 0;
            for (Integer i : data) {
                sum += i.intValue();
            }
            return sum;
        }
    }

    private static final class ConvertingInitializer
    implements BroadcastVariableInitializer<Integer, List<Double>> {
        private ConvertingInitializer() {
        }

        public List<Double> initializeBroadcastVariable(Iterable<Integer> data) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Integer i : data) {
                list.add(i.doubleValue());
            }
            return list;
        }
    }
}

