/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.api.common.io.InputStreamFSInputWrapper;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.types.IntValue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileInputFormatTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testGetPathWithoutSettingFirst() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        Assert.assertNull((String)"Path should be null.", (Object)format.getFilePath());
    }

    @Test
    public void testGetPathsWithoutSettingFirst() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        Path[] paths = format.getFilePaths();
        Assert.assertNotNull((String)"Paths should not be null.", (Object)paths);
        Assert.assertEquals((String)"Paths size should be 0.", (long)0L, (long)paths.length);
    }

    @Test
    public void testToStringWithoutPathSet() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        Assert.assertEquals((String)"The toString() should be correct.", (Object)"File Input (unknown file)", (Object)format.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPathsNull() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPathNullString() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPathNullPath() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPathsOnePathNull() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{"/an/imaginary/path", null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPathsEmptyArray() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[0]);
    }

    @Test
    public void testSetPath() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath("/some/imaginary/path");
        Assert.assertEquals((Object)format.getFilePath().toString(), (Object)"/some/imaginary/path");
    }

    @Test
    public void testSetPathOnMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        format.setFilePath("/an/imaginary/path");
        Path[] filePaths = format.getFilePaths();
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"/an/imaginary/path", (Object)filePaths[0].toUri().toString());
        Assert.assertEquals((Object)"/an/imaginary/path", (Object)format.filePath.toUri().toString());
    }

    @Test
    public void testSetPathsSingleWithMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        format.setFilePaths(new String[]{"/an/imaginary/path"});
        Path[] filePaths = format.getFilePaths();
        Assert.assertEquals((long)1L, (long)filePaths.length);
        Assert.assertEquals((Object)"/an/imaginary/path", (Object)filePaths[0].toUri().toString());
        Assert.assertEquals((Object)"/an/imaginary/path", (Object)format.filePath.toUri().toString());
    }

    @Test
    public void testSetPathsMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"});
        Path[] filePaths = format.getFilePaths();
        Assert.assertEquals((long)2L, (long)filePaths.length);
        Assert.assertEquals((Object)"/an/imaginary/path", (Object)filePaths[0].toUri().toString());
        Assert.assertEquals((Object)"/an/imaginary/path2", (Object)filePaths[1].toUri().toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMultiPathSetOnSinglePathIF() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMultiPathSetOnSinglePathIF2() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new Path[]{new Path("/an/imaginary/path"), new Path("/an/imaginary/path2")});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSinglePathGetOnMultiPathIF() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"});
        format.getFilePath();
    }

    @Test
    public void testSetFileViaConfiguration() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String filePath = "file:///some/none/existing/directory/";
        Configuration conf = new Configuration();
        conf.setString("input.file.path", "file:///some/none/existing/directory/");
        format.configure(conf);
        Assert.assertEquals((String)"Paths should be equal.", (Object)new Path("file:///some/none/existing/directory/"), (Object)format.getFilePath());
    }

    @Test(expected=RuntimeException.class)
    public void testSetFileViaConfigurationEmptyPath() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String filePath = null;
        Configuration conf = new Configuration();
        conf.setString("input.file.path", filePath);
        format.configure(conf);
    }

    @Test
    public void testCreateInputSplitSingleFile() throws IOException {
        String tempFile = TestFileUtils.createTempFile("Hello World");
        DummyFileInputFormat fif = new DummyFileInputFormat();
        fif.setFilePath(tempFile);
        fif.configure(new Configuration());
        FileInputSplit[] splits = fif.createInputSplits(2);
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertEquals((Object)tempFile, (Object)splits[0].getPath().toString());
        Assert.assertEquals((Object)tempFile, (Object)splits[1].getPath().toString());
    }

    @Test
    public void testCreateInputSplitMultiFiles() throws IOException {
        String tempFile1 = TestFileUtils.createTempFile(21L);
        String tempFile2 = TestFileUtils.createTempFile(22L);
        String tempFile3 = TestFileUtils.createTempFile(23L);
        MultiDummyFileInputFormat fif = new MultiDummyFileInputFormat();
        fif.setFilePaths(new String[]{tempFile1, tempFile2, tempFile3});
        fif.configure(new Configuration());
        FileInputSplit[] splits = fif.createInputSplits(3);
        int numSplitsFile1 = 0;
        int numSplitsFile2 = 0;
        int numSplitsFile3 = 0;
        Assert.assertEquals((long)3L, (long)splits.length);
        for (FileInputSplit fis : splits) {
            Assert.assertEquals((long)0L, (long)fis.getStart());
            if (fis.getPath().toString().equals(tempFile1)) {
                ++numSplitsFile1;
                Assert.assertEquals((long)21L, (long)fis.getLength());
                continue;
            }
            if (fis.getPath().toString().equals(tempFile2)) {
                ++numSplitsFile2;
                Assert.assertEquals((long)22L, (long)fis.getLength());
                continue;
            }
            if (fis.getPath().toString().equals(tempFile3)) {
                ++numSplitsFile3;
                Assert.assertEquals((long)23L, (long)fis.getLength());
                continue;
            }
            Assert.fail((String)"Got split for unknown file.");
        }
        Assert.assertEquals((long)1L, (long)numSplitsFile1);
        Assert.assertEquals((long)1L, (long)numSplitsFile2);
        Assert.assertEquals((long)1L, (long)numSplitsFile3);
    }

    @Test
    public void testGetStatisticsNonExistingFile() {
        try {
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath("file:///some/none/existing/directory/");
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertNull((String)"The file statistics should be null.", (Object)stats);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsOneFileNoCachedVersion() {
        try {
            long SIZE = 512000L;
            String tempFile = TestFileUtils.createTempFile(512000L);
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)512000L, (long)stats.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsMultipleFilesNoCachedVersion() {
        try {
            long SIZE1 = 2077L;
            long SIZE2 = 31909L;
            long SIZE3 = 10L;
            long TOTAL = 33996L;
            String tempDir = TestFileUtils.createTempFileDir(this.temporaryFolder.newFolder(), 2077L, 31909L, 10L);
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(tempDir);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)33996L, (long)stats.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsOneFileWithCachedVersion() {
        try {
            long SIZE = 50873L;
            long FAKE_SIZE = 10065L;
            String tempFile = TestFileUtils.createTempFile(50873L);
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)50873L, (long)stats.getTotalInputSize());
            format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
            Assert.assertTrue((String)"Statistics object was changed", (newStats == stats ? 1 : 0) != 0);
            format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
            FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)10065L, (long)latest.getTotalInputSize());
            format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime() - 1L, 10065L, -1.0f);
            FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)50873L, (long)reGathered.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsMultipleFilesWithCachedVersion() {
        try {
            FileSystem fs = FileSystem.getLocalFileSystem();
            long SIZE1 = 2077L;
            long SIZE2 = 31909L;
            long SIZE3 = 10L;
            long TOTAL = 33996L;
            long FAKE_SIZE = 10065L;
            File tempDirFile = this.temporaryFolder.newFolder();
            String tempDir = tempDirFile.getAbsolutePath();
            String f1 = TestFileUtils.createTempFileInDirectory(tempDir, 2077L);
            long modTime1 = fs.getFileStatus(new Path(f1)).getModificationTime();
            String f2 = TestFileUtils.createTempFileInDirectory(tempDir, 31909L);
            long modTime2 = fs.getFileStatus(new Path(f2)).getModificationTime();
            String f3 = TestFileUtils.createTempFileInDirectory(tempDir, 10L);
            long modTime3 = fs.getFileStatus(new Path(f3)).getModificationTime();
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(tempDir);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)33996L, (long)stats.getTotalInputSize());
            format = new DummyFileInputFormat();
            format.setFilePath(tempDir);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
            Assert.assertTrue((String)"Statistics object was changed", (newStats == stats ? 1 : 0) != 0);
            format = new DummyFileInputFormat();
            format.setFilePath(tempDir);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
            FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)10065L, (long)latest.getTotalInputSize());
            format = new DummyFileInputFormat();
            format.setFilePath(tempDir);
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(Math.min(Math.min(modTime1, modTime2), modTime3) - 1L, 10065L, -1.0f);
            FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)33996L, (long)reGathered.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsMultipleNonExistingFile() throws IOException {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{"file:///some/none/existing/directory/", "file:///another/non/existing/directory/"});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        Assert.assertNull((String)"The file statistics should be null.", (Object)stats);
    }

    @Test
    public void testGetStatisticsMultipleOneFileNoCachedVersion() throws IOException {
        long size1 = 512000L;
        String tempFile = TestFileUtils.createTempFile(512000L);
        long size2 = 517120L;
        String tempFile2 = TestFileUtils.createTempFile(517120L);
        long totalSize = 1029120L;
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)1029120L, (long)stats.getTotalInputSize());
    }

    @Test
    public void testGetStatisticsMultipleFilesMultiplePathsNoCachedVersion() throws IOException {
        long size1 = 2077L;
        long size2 = 31909L;
        long size3 = 10L;
        long totalSize123 = 33996L;
        String tempDir = TestFileUtils.createTempFileDir(this.temporaryFolder.newFolder(), 2077L, 31909L, 10L);
        long size4 = 2051L;
        long size5 = 31902L;
        long size6 = 15L;
        long totalSize456 = 33968L;
        String tempDir2 = TestFileUtils.createTempFileDir(this.temporaryFolder.newFolder(), 2051L, 31902L, 15L);
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempDir, tempDir2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)67964L, (long)stats.getTotalInputSize());
    }

    @Test
    public void testGetStatisticsMultipleOneFileWithCachedVersion() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        long size1 = 50873L;
        long fakeSize = 10065L;
        String tempFile1 = TestFileUtils.createTempFile(50873L);
        long lastModTime1 = fs.getFileStatus(new Path(tempFile1)).getModificationTime();
        long size2 = 52573L;
        String tempFile2 = TestFileUtils.createTempFile(52573L);
        long lastModTime2 = fs.getFileStatus(new Path(tempFile2)).getModificationTime();
        long sizeTotal = 103446L;
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile1, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)103446L, (long)stats.getTotalInputSize());
        format = new MultiDummyFileInputFormat();
        format.setFilePath(tempFile1);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
        Assert.assertTrue((String)"Statistics object was changed", (newStats == stats ? 1 : 0) != 0);
        format = new MultiDummyFileInputFormat();
        format.setFilePath(tempFile1);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
        Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)10065L, (long)latest.getTotalInputSize());
        format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile1, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(Math.min(lastModTime1, lastModTime2) - 1L, 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
        Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)103446L, (long)reGathered.getTotalInputSize());
    }

    @Test
    public void testFileInputSplit() {
        try {
            String tempFile = TestFileUtils.createTempFileDirExtension(this.temporaryFolder.newFolder(), ".deflate", "some", "stupid", "meaningless", "files");
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(tempFile);
            format.configure(new Configuration());
            FileInputSplit[] splits = format.createInputSplits(2);
            Assert.assertEquals((long)4L, (long)splits.length);
            for (FileInputSplit split : splits) {
                Assert.assertEquals((long)-1L, (long)split.getLength());
                Assert.assertEquals((long)0L, (long)split.getStart());
            }
            TestFileUtils.createTempFileInDirectory(tempFile.replace("file:", ""), "this creates a test file with a random extension (at least not .deflate)");
            DummyFileInputFormat formatMixed = new DummyFileInputFormat();
            formatMixed.setFilePath(tempFile);
            formatMixed.configure(new Configuration());
            FileInputSplit[] splitsMixed = formatMixed.createInputSplits(2);
            Assert.assertEquals((long)5L, (long)splitsMixed.length);
            for (FileInputSplit split : splitsMixed) {
                if (split.getPath().getName().endsWith(".deflate")) {
                    Assert.assertEquals((long)-1L, (long)split.getLength());
                    Assert.assertEquals((long)0L, (long)split.getStart());
                    continue;
                }
                Assert.assertEquals((long)0L, (long)split.getStart());
                Assert.assertTrue((String)"split size not correct", (split.getLength() > 0L ? 1 : 0) != 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testIgnoredUnderscoreFiles() {
        try {
            String contents = "CONTENTS";
            File child1 = this.temporaryFolder.newFile("dataFile1.txt");
            File child2 = this.temporaryFolder.newFile("another_file.bin");
            File luigiFile = this.temporaryFolder.newFile("_luigi");
            File success = this.temporaryFolder.newFile("_SUCCESS");
            this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), child1, child2, luigiFile, success);
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(this.temporaryFolder.getRoot().toURI().toString());
            format.configure(new Configuration());
            FileInputSplit[] splits = format.createInputSplits(1);
            Assert.assertEquals((long)2L, (long)splits.length);
            URI uri1 = splits[0].getPath().toUri();
            URI uri2 = splits[1].getPath().toUri();
            URI childUri1 = child1.toURI();
            URI childUri2 = child2.toURI();
            Assert.assertTrue((uri1.equals(childUri1) && uri2.equals(childUri2) || uri1.equals(childUri2) && uri2.equals(childUri1) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExcludeFiles() {
        try {
            String contents = "CONTENTS";
            File child1 = this.temporaryFolder.newFile("dataFile1.txt");
            File child2 = this.temporaryFolder.newFile("another_file.bin");
            File[] files = new File[]{child1, child2};
            this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), files);
            Configuration configuration = new Configuration();
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(this.temporaryFolder.getRoot().toURI().toString());
            format.configure(configuration);
            format.setFilesFilter((FilePathFilter)new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("**/another_file.bin")));
            FileInputSplit[] splits = format.createInputSplits(1);
            Assert.assertEquals((long)1L, (long)splits.length);
            URI uri1 = splits[0].getPath().toUri();
            URI childUri1 = child1.toURI();
            Assert.assertEquals((Object)uri1, (Object)childUri1);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadMultiplePatterns() throws Exception {
        String contents = "CONTENTS";
        File child1 = this.temporaryFolder.newFile("dataFile1.txt");
        File child2 = this.temporaryFolder.newFile("another_file.bin");
        this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), child1, child2);
        Configuration configuration = new Configuration();
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(this.temporaryFolder.getRoot().toURI().toString());
        format.configure(configuration);
        format.setFilesFilter((FilePathFilter)new GlobFilePathFilter(Collections.singletonList("**"), Arrays.asList("**/another_file.bin", "**/dataFile1.txt")));
        FileInputSplit[] splits = format.createInputSplits(1);
        Assert.assertEquals((long)0L, (long)splits.length);
    }

    @Test
    public void testGetStatsIgnoredUnderscoreFiles() {
        try {
            int SIZE = 2048;
            long TOTAL = 4096L;
            File child1 = this.temporaryFolder.newFile("dataFile1.txt");
            File child2 = this.temporaryFolder.newFile("another_file.bin");
            File luigiFile = this.temporaryFolder.newFile("_luigi");
            File success = this.temporaryFolder.newFile("_SUCCESS");
            this.createTempFiles(new byte[2048], child1, child2, luigiFile, success);
            DummyFileInputFormat format = new DummyFileInputFormat();
            format.setFilePath(this.temporaryFolder.getRoot().toURI().toString());
            format.configure(new Configuration());
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((long)4096L, (long)stats.getTotalInputSize());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDecorateInputStream() throws IOException {
        File tempFile = File.createTempFile("input-stream-decoration-test", "tmp");
        tempFile.deleteOnExit();
        int blockSize = 8;
        int numBlocks = 3;
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        for (int i = 0; i < 24; ++i) {
            fileOutputStream.write(new byte[]{(byte)i});
        }
        fileOutputStream.close();
        Configuration config = new Configuration();
        MyDecoratedInputFormat inputFormat = new MyDecoratedInputFormat();
        inputFormat.setFilePath(tempFile.toURI().toString());
        inputFormat.configure(config);
        inputFormat.openInputFormat();
        FileInputSplit[] inputSplits = inputFormat.createInputSplits(3);
        byte[] bytes = null;
        byte prev = 0;
        for (FileInputSplit inputSplit : inputSplits) {
            inputFormat.open(inputSplit);
            while (!inputFormat.reachedEnd()) {
                if ((bytes = (byte[])inputFormat.nextRecord(bytes)) == null) continue;
                Assert.assertArrayEquals((byte[])new byte[]{prev = (byte)((byte)(prev - 1))}, (byte[])bytes);
            }
        }
        inputFormat.closeInputFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFiles(byte[] contents, File ... files) throws IOException {
        for (File child : files) {
            child.deleteOnExit();
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(child));){
                out.write(contents);
            }
        }
    }

    private static final class InvertedInputStream
    extends InputStream {
        private final InputStream originalStream;

        private InvertedInputStream(InputStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public int read() throws IOException {
            int read = this.originalStream.read();
            return read == -1 ? -1 : ~read & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.originalStream.available();
        }
    }

    private static final class MyDecoratedInputFormat
    extends FileInputFormat<byte[]> {
        private static final long serialVersionUID = 1L;

        private MyDecoratedInputFormat() {
        }

        public boolean reachedEnd() throws IOException {
            return this.stream.getPos() >= this.splitStart + this.splitLength;
        }

        public byte[] nextRecord(byte[] reuse) throws IOException {
            int read = this.stream.read();
            if (read == -1) {
                throw new IllegalStateException();
            }
            return new byte[]{(byte)read};
        }

        protected FSDataInputStream decorateInputStream(FSDataInputStream inputStream, FileInputSplit fileSplit) throws Throwable {
            inputStream = super.decorateInputStream(inputStream, fileSplit);
            return new InputStreamFSInputWrapper((InputStream)new InvertedInputStream((InputStream)inputStream));
        }
    }

    private class MultiDummyFileInputFormat
    extends DummyFileInputFormat {
        private static final long serialVersionUID = 1L;

        private MultiDummyFileInputFormat() {
        }

        public boolean supportsMultiPaths() {
            return true;
        }
    }

    private class DummyFileInputFormat
    extends FileInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;

        private DummyFileInputFormat() {
        }

        public boolean reachedEnd() throws IOException {
            return true;
        }

        public IntValue nextRecord(IntValue record) throws IOException {
            return null;
        }
    }
}

