/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.junit.Assert;
import org.junit.Test;

public class DualInputSemanticPropertiesTest {
    @Test
    public void testGetTargetFields() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 1);
        sp.addForwardedField(0, 1, 4);
        sp.addForwardedField(0, 2, 3);
        sp.addForwardedField(0, 3, 2);
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 2).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 3).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(0, 4));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(0, 4).size());
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 1, 1);
        sp.addForwardedField(0, 1, 2);
        sp.addForwardedField(0, 1, 3);
        Assert.assertEquals((long)2L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)3L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(0, 2));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(0, 2).size());
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        sp.addForwardedField(1, 2, 3);
        sp.addForwardedField(1, 3, 2);
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 1).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 2).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 3).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(2)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(1, 4));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(1, 4).size());
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 0);
        sp.addForwardedField(1, 0, 4);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 1, 3);
        Assert.assertEquals((long)2L, (long)sp.getForwardingTargetFields(1, 0).size());
        Assert.assertEquals((long)3L, (long)sp.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(3)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(1, 2));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(1, 2).size());
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 2, 6);
        sp.addForwardedField(0, 7, 8);
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 2).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 7).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(6)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 7).contains(Integer.valueOf(8)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(4)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(0, 1));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(1, 4));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(1, 4).size());
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 3, 8);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 4, 8);
        Assert.assertEquals((long)2L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 3).size());
        Assert.assertEquals((long)2L, (long)sp.getForwardingTargetFields(1, 1).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(1, 4).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(8)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(8)));
    }

    @Test
    public void testGetSourceField() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 1);
        sp.addForwardedField(0, 1, 4);
        sp.addForwardedField(0, 2, 3);
        sp.addForwardedField(0, 3, 2);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 4));
        Assert.assertEquals((long)2L, (long)sp.getForwardingSourceField(0, 3));
        Assert.assertEquals((long)3L, (long)sp.getForwardingSourceField(0, 2));
        Assert.assertTrue((sp.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingSourceField(0, 5) < 0 ? 1 : 0) != 0);
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 1, 1);
        sp.addForwardedField(0, 1, 2);
        sp.addForwardedField(0, 1, 3);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 0));
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 4));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 2));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 3));
        Assert.assertTrue((sp.getForwardingSourceField(0, 5) < 0 ? 1 : 0) != 0);
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        sp.addForwardedField(1, 2, 3);
        sp.addForwardedField(1, 3, 2);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(1, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(1, 4));
        Assert.assertEquals((long)2L, (long)sp.getForwardingSourceField(1, 3));
        Assert.assertEquals((long)3L, (long)sp.getForwardingSourceField(1, 2));
        Assert.assertTrue((sp.getForwardingSourceField(1, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingSourceField(1, 5) < 0 ? 1 : 0) != 0);
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 0);
        sp.addForwardedField(1, 0, 4);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 1, 3);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(1, 0));
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(1, 4));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(1, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(1, 2));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(1, 3));
        Assert.assertTrue((sp.getForwardingSourceField(1, 5) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReadSet() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addReadFields(0, new FieldSet(new int[]{0, 1}));
        Assert.assertEquals((long)2L, (long)sp.getReadFields(0).size());
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(1)));
        sp.addReadFields(0, new FieldSet(Integer.valueOf(3)));
        Assert.assertEquals((long)3L, (long)sp.getReadFields(0).size());
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(3)));
        sp = new DualInputSemanticProperties();
        sp.addReadFields(1, new FieldSet(new int[]{0, 1}));
        Assert.assertEquals((long)2L, (long)sp.getReadFields(1).size());
        Assert.assertTrue((boolean)sp.getReadFields(1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(1).contains(Integer.valueOf(1)));
        sp.addReadFields(1, new FieldSet(Integer.valueOf(3)));
        Assert.assertEquals((long)3L, (long)sp.getReadFields(1).size());
        Assert.assertTrue((boolean)sp.getReadFields(1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getReadFields(1).contains(Integer.valueOf(3)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testAddForwardedFieldsTargetTwice1() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 2);
        sp.addForwardedField(0, 1, 2);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testAddForwardedFieldsTargetTwice2() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 2);
        sp.addForwardedField(1, 1, 2);
    }
}

