/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.TestIOData;
import org.apache.flink.api.common.operators.util.TestNonRichInputFormat;
import org.apache.flink.api.common.operators.util.TestNonRichOutputFormat;
import org.apache.flink.api.common.operators.util.TestRichOutputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.types.Nothing;
import org.junit.Assert;
import org.junit.Test;

public class GenericDataSinkBaseTest
implements Serializable {
    private static TestNonRichInputFormat in = new TestNonRichInputFormat();
    GenericDataSourceBase<String, TestNonRichInputFormat> source = new GenericDataSourceBase((InputFormat)in, new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "testSource");

    @Test
    public void testDataSourcePlain() {
        try {
            TestNonRichOutputFormat out = new TestNonRichOutputFormat();
            GenericDataSinkBase sink = new GenericDataSinkBase((OutputFormat)out, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.getInfoFor(Nothing.class)), "test_sink");
            sink.setInput(this.source);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            in.reset();
            sink.executeOnCollections(Arrays.asList(TestIOData.NAMES), null, executionConfig);
            Assert.assertEquals(out.output, Arrays.asList(TestIOData.NAMES));
            executionConfig.enableObjectReuse();
            out.clear();
            in.reset();
            sink.executeOnCollections(Arrays.asList(TestIOData.NAMES), null, executionConfig);
            Assert.assertEquals(out.output, Arrays.asList(TestIOData.NAMES));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDataSourceWithRuntimeContext() {
        try {
            TestRichOutputFormat out = new TestRichOutputFormat();
            GenericDataSinkBase sink = new GenericDataSinkBase((OutputFormat)out, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.getInfoFor(Nothing.class)), "test_sink");
            sink.setInput(this.source);
            ExecutionConfig executionConfig = new ExecutionConfig();
            HashMap accumulatorMap = new HashMap();
            HashMap cpTasks = new HashMap();
            TaskInfo taskInfo = new TaskInfo("test_sink", 1, 0, 1, 0);
            executionConfig.disableObjectReuse();
            in.reset();
            sink.executeOnCollections(Arrays.asList(TestIOData.NAMES), (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals(out.output, Arrays.asList(TestIOData.RICH_NAMES));
            executionConfig.enableObjectReuse();
            out.clear();
            in.reset();
            sink.executeOnCollections(Arrays.asList(TestIOData.NAMES), (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals(out.output, Arrays.asList(TestIOData.RICH_NAMES));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

