/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceSpecTest
extends TestLogger {
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    @Test
    public void testLessThanOrEqualWhenBothSpecified() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertTrue((boolean)rs1.lessThanOrEqual(rs2));
        Assert.assertTrue((boolean)rs2.lessThanOrEqual(rs1));
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assert.assertTrue((boolean)rs1.lessThanOrEqual(rs3));
        Assert.assertFalse((boolean)rs3.lessThanOrEqual(rs1));
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assert.assertFalse((boolean)rs4.lessThanOrEqual(rs3));
        Assert.assertTrue((boolean)rs3.lessThanOrEqual(rs4));
    }

    @Test
    public void testLessThanOrEqualWhenBothUnknown() {
        Assert.assertTrue((boolean)ResourceSpec.UNKNOWN.lessThanOrEqual(ResourceSpec.UNKNOWN));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLessThanOrEqualWhenUnknownWithSpecified() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertTrue((boolean)ResourceSpec.UNKNOWN.lessThanOrEqual(rs1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLessThanOrEqualWhenSpecifiedWithUnknown() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertTrue((boolean)rs1.lessThanOrEqual(ResourceSpec.UNKNOWN));
    }

    @Test
    public void testEquals() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertEquals((Object)rs1, (Object)rs2);
        Assert.assertEquals((Object)rs2, (Object)rs1);
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertNotEquals((Object)rs3, (Object)rs4);
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assert.assertEquals((Object)rs3, (Object)rs5);
    }

    @Test
    public void testHashCode() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assert.assertEquals((long)rs1.hashCode(), (long)rs2.hashCode());
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertNotEquals((long)rs3.hashCode(), (long)rs4.hashCode());
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assert.assertEquals((long)rs3.hashCode(), (long)rs5.hashCode());
    }

    @Test
    public void testMerge() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs3 = rs1.merge(rs2);
        Assert.assertEquals((Object)new CPUResource(2.0), (Object)rs3.getCpuCores());
        Assert.assertEquals((long)200L, (long)rs3.getTaskHeapMemory().getMebiBytes());
        Assert.assertEquals((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1), rs3.getExtendedResource(EXTERNAL_RESOURCE_NAME).get());
        ResourceSpec rs4 = rs1.merge(rs3);
        Assert.assertEquals((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2), rs4.getExtendedResource(EXTERNAL_RESOURCE_NAME).get());
    }

    @Test
    public void testSerializable() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)rs1);
        Assert.assertEquals((Object)rs1, (Object)rs2);
    }

    @Test
    public void testMergeThisUnknown() throws Exception {
        ResourceSpec spec1 = ResourceSpec.UNKNOWN;
        ResourceSpec spec2 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec merged = spec1.merge(spec2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)merged);
    }

    @Test
    public void testMergeOtherUnknown() throws Exception {
        ResourceSpec spec1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec spec2 = ResourceSpec.UNKNOWN;
        ResourceSpec merged = spec1.merge(spec2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)merged);
    }

    @Test
    public void testMergeBothUnknown() throws Exception {
        ResourceSpec spec1 = ResourceSpec.UNKNOWN;
        ResourceSpec spec2 = ResourceSpec.UNKNOWN;
        ResourceSpec merged = spec1.merge(spec2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)merged);
    }

    @Test
    public void testMergeWithSerializationCopy() throws Exception {
        ResourceSpec spec1 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceSpec spec2 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceSpec merged = spec1.merge(spec2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)merged);
    }

    @Test
    public void testSingletonPropertyOfUnknown() throws Exception {
        ResourceSpec copiedSpec = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        Assert.assertSame((Object)ResourceSpec.UNKNOWN, (Object)copiedSpec);
    }

    @Test
    public void testSubtract() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.5)).build();
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assert.assertEquals((Object)new CPUResource(0.8), (Object)subtracted.getCpuCores());
        Assert.assertEquals((long)0L, (long)subtracted.getTaskHeapMemory().getMebiBytes());
        Assert.assertEquals((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.6), subtracted.getExtendedResource(EXTERNAL_RESOURCE_NAME).get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractOtherHasLargerResources() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)200).build();
        rs1.subtract(rs2);
    }

    @Test
    public void testSubtractThisUnknown() {
        ResourceSpec rs1 = ResourceSpec.UNKNOWN;
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.5)).build();
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)subtracted);
    }

    @Test
    public void testSubtractOtherUnknown() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.UNKNOWN;
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)subtracted);
    }

    @Test
    public void testZeroExtendedResourceFromConstructor() {
        ResourceSpec resourceSpec = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.0)).build();
        Assert.assertEquals((long)resourceSpec.getExtendedResources().size(), (long)0L);
    }

    @Test
    public void testZeroExtendedResourceFromSubtract() {
        ResourceSpec resourceSpec = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assert.assertEquals((long)resourceSpec.subtract(resourceSpec).getExtendedResources().size(), (long)0L);
    }
}

