/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapPartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class PartitionMapOperatorTest
implements Serializable {
    @Test
    public void testMapPartitionWithRuntimeContext() {
        try {
            String taskName = "Test Task";
            final AtomicBoolean opened = new AtomicBoolean();
            final AtomicBoolean closed = new AtomicBoolean();
            RichMapPartitionFunction<String, Integer> parser = new RichMapPartitionFunction<String, Integer>(){

                public void open(Configuration parameters) throws Exception {
                    opened.set(true);
                    RuntimeContext ctx = this.getRuntimeContext();
                    Assert.assertEquals((long)0L, (long)ctx.getIndexOfThisSubtask());
                    Assert.assertEquals((long)1L, (long)ctx.getNumberOfParallelSubtasks());
                    Assert.assertEquals((Object)"Test Task", (Object)ctx.getTaskName());
                }

                public void mapPartition(Iterable<String> values, Collector<Integer> out) {
                    for (String s : values) {
                        out.collect((Object)Integer.parseInt(s));
                    }
                }

                public void close() throws Exception {
                    closed.set(true);
                }
            };
            MapPartitionOperatorBase op = new MapPartitionOperatorBase((MapPartitionFunction)parser, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), "Test Task");
            ArrayList<String> input = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
            TaskInfo taskInfo = new TaskInfo("Test Task", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultMutableSafe);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultRegular);
            Assert.assertTrue((boolean)opened.get());
            Assert.assertTrue((boolean)closed.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

