/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.TypeInformationSerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TypeInformationSerializationSchemaTest {
    @Test
    public void testDeSerialization() {
        try {
            MyPOJO[] types;
            TypeInformation info = TypeExtractor.getForClass(MyPOJO.class);
            TypeInformationSerializationSchema schema = new TypeInformationSerializationSchema(info, new ExecutionConfig());
            for (MyPOJO val : types = new MyPOJO[]{new MyPOJO(72, new Date(763784523L), new Date(88234L)), new MyPOJO(-1, new Date(11111111111111L)), new MyPOJO(42, new Date[0]), new MyPOJO(17, new Date(222763784523L))}) {
                byte[] serialized = schema.serialize((Object)val);
                MyPOJO deser = (MyPOJO)schema.deserialize(serialized);
                Assert.assertEquals((Object)val, (Object)deser);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerializability() {
        try {
            TypeInformation info = TypeExtractor.getForClass(MyPOJO.class);
            TypeInformationSerializationSchema schema = new TypeInformationSerializationSchema(info, new ExecutionConfig());
            CommonTestUtils.createCopySerializable((Serializable)schema);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class MyPOJO {
        public int aField;
        public List<Date> aList;

        public MyPOJO() {
        }

        public MyPOJO(int iVal, Date ... dates) {
            this.aField = iVal;
            this.aList = new ArrayList<Date>(Arrays.asList(dates));
        }

        public int hashCode() {
            return this.aField;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MyPOJO) {
                MyPOJO that = (MyPOJO)obj;
                return this.aField == that.aField && (this.aList == null ? that.aList == null : that.aList != null && this.aList.equals(that.aList));
            }
            return super.equals(obj);
        }

        public String toString() {
            return "MyPOJO " + this.aField + " " + this.aList;
        }
    }
}

