/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class StateDescriptorTest {
    @Test
    public void testInitializeWithSerializer() throws Exception {
        StringSerializer serializer = StringSerializer.INSTANCE;
        TestStateDescriptor descr = new TestStateDescriptor("test", serializer);
        Assert.assertTrue((boolean)descr.isSerializerInitialized());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertTrue((boolean)(descr.getSerializer() instanceof StringSerializer));
        descr.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertTrue((boolean)descr.isSerializerInitialized());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertTrue((boolean)(descr.getSerializer() instanceof StringSerializer));
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assert.assertTrue((boolean)clone.isSerializerInitialized());
        Assert.assertNotNull((Object)clone.getSerializer());
        Assert.assertTrue((boolean)(clone.getSerializer() instanceof StringSerializer));
    }

    @Test
    public void testInitializeSerializerBeforeSerialization() throws Exception {
        TestStateDescriptor<String> descr = new TestStateDescriptor<String>("test", String.class);
        Assert.assertFalse((boolean)descr.isSerializerInitialized());
        try {
            descr.getSerializer();
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        descr.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertTrue((boolean)descr.isSerializerInitialized());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertTrue((boolean)(descr.getSerializer() instanceof StringSerializer));
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assert.assertTrue((boolean)clone.isSerializerInitialized());
        Assert.assertNotNull((Object)clone.getSerializer());
        Assert.assertTrue((boolean)(clone.getSerializer() instanceof StringSerializer));
    }

    @Test
    public void testInitializeSerializerAfterSerialization() throws Exception {
        TestStateDescriptor<String> descr = new TestStateDescriptor<String>("test", String.class);
        Assert.assertFalse((boolean)descr.isSerializerInitialized());
        try {
            descr.getSerializer();
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assert.assertFalse((boolean)clone.isSerializerInitialized());
        try {
            clone.getSerializer();
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertTrue((boolean)clone.isSerializerInitialized());
        Assert.assertNotNull((Object)clone.getSerializer());
        Assert.assertTrue((boolean)(clone.getSerializer() instanceof StringSerializer));
    }

    @Test
    public void testInitializeSerializerAfterSerializationWithCustomConfig() throws Exception {
        Assert.assertEquals((String)"broken test assumption", (long)-1L, (long)new KryoSerializer(String.class, new ExecutionConfig()).getKryo().getRegistration(File.class).getId());
        ExecutionConfig config = new ExecutionConfig();
        config.registerKryoType(File.class);
        TestStateDescriptor<Path> original = new TestStateDescriptor<Path>("test", Path.class);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(original));
        clone.initializeSerializerUnlessSet(config);
        Assert.assertTrue((((KryoSerializer)clone.getSerializer()).getKryo().getRegistration(File.class).getId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializerDuplication() throws Exception {
        KryoSerializer statefulSerializer = new KryoSerializer(String.class, new ExecutionConfig());
        TestStateDescriptor descr = new TestStateDescriptor("foobar", statefulSerializer);
        TypeSerializer serializerA = descr.getSerializer();
        TypeSerializer serializerB = descr.getSerializer();
        Assert.assertNotSame((Object)serializerA, (Object)serializerB);
    }

    @Test
    public void testHashCodeAndEquals() throws Exception {
        String name = "testName";
        TestStateDescriptor<String> original = new TestStateDescriptor<String>("testName", String.class);
        TestStateDescriptor<String> same = new TestStateDescriptor<String>("testName", String.class);
        TestStateDescriptor sameBySerializer = new TestStateDescriptor("testName", StringSerializer.INSTANCE);
        Assert.assertEquals((long)original.hashCode(), (long)same.hashCode());
        Assert.assertEquals((long)original.hashCode(), (long)sameBySerializer.hashCode());
        Assert.assertEquals(original, same);
        Assert.assertEquals(original, sameBySerializer);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(original));
        Assert.assertEquals(original, (Object)((Object)clone));
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals(original, (Object)((Object)clone));
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals(original, same);
    }

    @Test
    public void testEqualsSameNameAndTypeDifferentClass() throws Exception {
        String name = "test name";
        TestStateDescriptor<String> descr1 = new TestStateDescriptor<String>("test name", String.class);
        OtherTestStateDescriptor<String> descr2 = new OtherTestStateDescriptor<String>("test name", String.class);
        Assert.assertNotEquals(descr1, descr2);
    }

    @Test
    public void testSerializerLazyInitializeInParallel() throws Exception {
        String name = "testSerializerLazyInitializeInParallel";
        final TestStateDescriptor desc = new TestStateDescriptor("testSerializerLazyInitializeInParallel", new PojoTypeInfo(String.class, new ArrayList()));
        int threadNumber = 20;
        ArrayList<CheckedThread> threads = new ArrayList<CheckedThread>(20);
        final ExecutionConfig executionConfig = new ExecutionConfig();
        final ConcurrentHashMap serializers = new ConcurrentHashMap();
        for (int i = 0; i < 20; ++i) {
            threads.add(new CheckedThread(){

                public void go() {
                    desc.initializeSerializerUnlessSet(executionConfig);
                    TypeSerializer serializer = desc.getOriginalSerializer();
                    serializers.put(System.identityHashCode(serializer), serializer);
                }
            });
        }
        threads.forEach(Thread::start);
        for (CheckedThread t : threads) {
            t.sync();
        }
        Assert.assertEquals((String)("Should use only one serializer but actually: " + serializers), (long)1L, (long)serializers.size());
        threads.clear();
    }

    @Test
    public void testStateTTlConfig() {
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("test-state", (TypeSerializer)IntSerializer.INSTANCE);
        stateDescriptor.enableTimeToLive(StateTtlConfig.newBuilder((Time)Time.minutes((long)60L)).build());
        Assert.assertTrue((boolean)stateDescriptor.getTtlConfig().isEnabled());
        stateDescriptor.enableTimeToLive(StateTtlConfig.DISABLED);
        Assert.assertFalse((boolean)stateDescriptor.getTtlConfig().isEnabled());
    }

    private static class OtherTestStateDescriptor<T>
    extends StateDescriptor<State, T> {
        private static final long serialVersionUID = 1L;

        OtherTestStateDescriptor(String name, TypeSerializer<T> serializer) {
            super(name, serializer, null);
        }

        OtherTestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, null);
        }

        OtherTestStateDescriptor(String name, Class<T> type) {
            super(name, type, null);
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }

    private static class TestStateDescriptor<T>
    extends StateDescriptor<State, T> {
        private static final long serialVersionUID = 1L;

        TestStateDescriptor(String name, TypeSerializer<T> serializer) {
            super(name, serializer, null);
        }

        TestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, null);
        }

        TestStateDescriptor(String name, Class<T> type) {
            super(name, type, null);
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }
}

