/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializer;
import org.apache.flink.types.Either;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeTypeSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    public CompositeTypeSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Object, Object> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("either-serializer", flinkVersion, EitherSerializerSetup.class, EitherSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("generic-array-serializer", flinkVersion, GenericArraySerializerSetup.class, GenericArraySerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class GenericArraySerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<String[]> {
        @Override
        public TypeSerializer<String[]> createUpgradedSerializer() {
            return new GenericArraySerializer(String.class, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Matcher<String[]> testDataMatcher() {
            String[] data = new String[]{"Apache", "Flink"};
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<String[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class GenericArraySerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<String[]> {
        @Override
        public TypeSerializer<String[]> createPriorSerializer() {
            return new GenericArraySerializer(String.class, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public String[] createTestData() {
            String[] data = new String[]{"Apache", "Flink"};
            return data;
        }
    }

    public static final class EitherSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Either<String, Integer>> {
        @Override
        public TypeSerializer<Either<String, Integer>> createUpgradedSerializer() {
            return new EitherSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        @Override
        public Matcher<Either<String, Integer>> testDataMatcher() {
            return Matchers.is((Object)new Either.Left((Object)"ApacheFlink"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<Either<String, Integer>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class EitherSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Either<String, Integer>> {
        @Override
        public TypeSerializer<Either<String, Integer>> createPriorSerializer() {
            return new EitherSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        @Override
        public Either<String, Integer> createTestData() {
            return new Either.Left((Object)"ApacheFlink");
        }
    }
}

