/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.testutils.migration.SchemaCompatibilityTestingSerializer;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTypeSerializerUtilTest {
    @Test
    public void testCompatibleAsIsIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] testSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer("first serializer"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer("second serializer")};
        Object[] testNewSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("first serializer"), new SchemaCompatibilityTestingSerializer("second serializer")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])testNewSerializers, (TypeSerializerSnapshot[])testSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleAsIs());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAsIs());
        Assert.assertArrayEquals((Object[])testNewSerializers, (Object[])intermediateCompatibilityResult.getNestedSerializers());
    }

    @Test
    public void testCompatibleWithReconfiguredSerializerIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] testSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterReconfiguration("b")};
        TypeSerializer[] testNewSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("a"), new SchemaCompatibilityTestingSerializer("b")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])testNewSerializers, (TypeSerializerSnapshot[])testSerializerSnapshots);
        Object[] expectedReconfiguredNestedSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("a"), new SchemaCompatibilityTestingSerializer("b")};
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleWithReconfiguredSerializer());
        Assert.assertArrayEquals((Object[])expectedReconfiguredNestedSerializers, (Object[])intermediateCompatibilityResult.getNestedSerializers());
    }

    @Test
    public void testCompatibleAfterMigrationIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] testSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterReconfiguration("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterMigration("b"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer("c")};
        TypeSerializer[] testNewSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("a"), new SchemaCompatibilityTestingSerializer("b"), new SchemaCompatibilityTestingSerializer("c")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])testNewSerializers, (TypeSerializerSnapshot[])testSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleAfterMigration());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAfterMigration());
    }

    @Test
    public void testIncompatibleIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] testSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsIncompatibleWithTheNextSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterReconfiguration(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterMigration()};
        TypeSerializer[] testNewSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer(), new SchemaCompatibilityTestingSerializer(), new SchemaCompatibilityTestingSerializer(), new SchemaCompatibilityTestingSerializer()};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])testNewSerializers, (TypeSerializerSnapshot[])testSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isIncompatible());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isIncompatible());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetFinalResultOnUndefinedReconfigureIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.undefinedReconfigureResult((TypeSerializer[])new TypeSerializer[]{IntSerializer.INSTANCE});
        intermediateCompatibilityResult.getFinalResult();
    }

    @Test(expected=IllegalStateException.class)
    public void testGetNestedSerializersOnCompatibleAfterMigrationIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedCompatibleAfterMigrationResult();
        intermediateCompatibilityResult.getNestedSerializers();
    }

    @Test(expected=IllegalStateException.class)
    public void testGetNestedSerializersOnIncompatibleIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedIncompatibleResult();
        intermediateCompatibilityResult.getNestedSerializers();
    }
}

