/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.ArtificialCNFExceptionThrowingClassLoader;
import org.apache.flink.util.InstantiationUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TypeSerializerSerializationUtilTest
implements Serializable {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSerializerSerialization() throws Exception {
        TypeSerializer deserializedSerializer;
        byte[] serialized;
        IntSerializer serializer = IntSerializer.INSTANCE;
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializer)serializer);
            serialized = out.toByteArray();
        }
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            deserializedSerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        Assert.assertEquals((Object)serializer, (Object)deserializedSerializer);
    }

    @Test
    public void testSerializerSerializationWithClassNotFound() throws Exception {
        TypeSerializer deserializedSerializer;
        byte[] serialized;
        IntSerializer serializer = IntSerializer.INSTANCE;
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializer)serializer);
            serialized = out.toByteArray();
        }
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            deserializedSerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)new ArtificialCNFExceptionThrowingClassLoader(Thread.currentThread().getContextClassLoader(), Collections.singleton(IntSerializer.class.getName())), (boolean)true);
        }
        Assert.assertTrue((boolean)(deserializedSerializer instanceof UnloadableDummyTypeSerializer));
        Assert.assertArrayEquals((byte[])InstantiationUtil.serializeObject((Object)serializer), (byte[])((UnloadableDummyTypeSerializer)deserializedSerializer).getActualBytes());
    }

    @Test
    public void testSerializerSerializationWithInvalidClass() throws Exception {
        TypeSerializer deserializedSerializer;
        byte[] serialized;
        IntSerializer serializer = IntSerializer.INSTANCE;
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializer)serializer);
            serialized = out.toByteArray();
        }
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            deserializedSerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)new ArtificialCNFExceptionThrowingClassLoader(Thread.currentThread().getContextClassLoader(), Collections.singleton(IntSerializer.class.getName())), (boolean)true);
        }
        Assert.assertTrue((boolean)(deserializedSerializer instanceof UnloadableDummyTypeSerializer));
    }

    @Test
    public void testSerializeConfigurationSnapshots() throws Exception {
        TypeSerializerSnapshot restoredConfigs;
        byte[] serializedConfig;
        TestConfigSnapshot configSnapshot1 = new TestConfigSnapshot(1, "foo");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), configSnapshot1, (TypeSerializer)StringSerializer.INSTANCE);
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfigs = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader(), null);
        }
        Assert.assertEquals(configSnapshot1, (Object)restoredConfigs);
    }

    @Test(expected=IOException.class)
    public void testFailsWhenConfigurationSnapshotClassNotFound() throws Exception {
        byte[] serializedConfig;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), new TestConfigSnapshot(123, "foobar"), (TypeSerializer)StringSerializer.INSTANCE);
            serializedConfig = out.toByteArray();
        }
        var3_2 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)new URLClassLoader(new URL[0], null), null);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        Assert.fail((String)"Expected a ClassNotFoundException wrapped in IOException");
    }

    @Test
    public void testSerializerAndConfigPairsSerializationWithSerializerDeserializationFailures() throws Exception {
        List restored;
        byte[] serializedSerializersAndConfigs;
        TestIntSerializer serializer = new TestIntSerializer();
        List<Tuple2> serializersAndConfigs = Arrays.asList(new Tuple2((Object)serializer, serializer.snapshotConfiguration()));
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), serializersAndConfigs);
            serializedSerializersAndConfigs = out.toByteArray();
        }
        HashSet<String> cnfThrowingClassnames = new HashSet<String>();
        cnfThrowingClassnames.add(TestIntSerializer.class.getName());
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedSerializersAndConfigs);){
            restored = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)new ArtificialCNFExceptionThrowingClassLoader(Thread.currentThread().getContextClassLoader(), cnfThrowingClassnames));
        }
        Assert.assertEquals((long)1L, (long)restored.size());
        Assert.assertTrue((boolean)(((Tuple2)restored.get((int)0)).f0 instanceof UnloadableDummyTypeSerializer));
        Assert.assertThat((Object)((Tuple2)restored.get((int)0)).f1, (Matcher)Matchers.instanceOf(SimpleTypeSerializerSnapshot.class));
    }

    @Test
    public void testAnonymousSerializerClassWithChangedSerialVersionUID() throws Exception {
        byte[] anonymousSerializerBytes;
        AbstractIntSerializer anonymousClassSerializer = new AbstractIntSerializer(){

            public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
                return null;
            }
        };
        Assert.assertTrue((boolean)((Object)((Object)anonymousClassSerializer)).getClass().isAnonymousClass());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializer)anonymousClassSerializer);
            anonymousSerializerBytes = out.toByteArray();
        }
        long newSerialVersionUID = 1234567L;
        Assert.assertNotEquals((long)ObjectStreamClass.lookup(((Object)((Object)anonymousClassSerializer)).getClass()).getSerialVersionUID(), (long)newSerialVersionUID);
        TypeSerializerSerializationUtilTest.modifySerialVersionUID(anonymousSerializerBytes, ((Object)((Object)anonymousClassSerializer)).getClass().getName(), newSerialVersionUID);
        try (ByteArrayInputStream in = new ByteArrayInputStream(anonymousSerializerBytes);){
            anonymousClassSerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        Assert.assertNotNull((Object)((Object)anonymousClassSerializer));
        Assert.assertTrue((boolean)((Object)((Object)anonymousClassSerializer)).getClass().isAnonymousClass());
    }

    private static void modifySerialVersionUID(byte[] objectBytes, String classname, long newSerialVersionUID) throws Exception {
        byte[] classnameBytes = classname.getBytes();
        boolean foundClass = false;
        int numMatchedBytes = 0;
        for (int serialVersionUIDOffset = 0; serialVersionUIDOffset < objectBytes.length; ++serialVersionUIDOffset) {
            if (objectBytes[serialVersionUIDOffset] == classnameBytes[numMatchedBytes]) {
                ++numMatchedBytes;
                foundClass = true;
            } else if (objectBytes[serialVersionUIDOffset] == classnameBytes[0]) {
                numMatchedBytes = 1;
            } else {
                numMatchedBytes = 0;
                foundClass = false;
            }
            if (numMatchedBytes == classnameBytes.length) break;
        }
        if (!foundClass) {
            throw new RuntimeException("Could not find class " + classname + " in object byte stream.");
        }
        byte[] newUIDBytes = ByteBuffer.allocate(8).putLong(newSerialVersionUID).array();
        for (int uidIndex = 0; uidIndex < newUIDBytes.length; ++uidIndex) {
            objectBytes[serialVersionUIDOffset + 1 + uidIndex] = newUIDBytes[uidIndex];
        }
    }

    public static class TestIntSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Integer> {
        public TestIntSerializerSnapshot() {
            super(TestIntSerializer::new);
        }
    }

    public static class TestIntSerializer
    extends AbstractIntSerializer {
        private static final long serialVersionUID = -3684467698271707216L;

        public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
            return new TestIntSerializerSnapshot();
        }
    }

    public static abstract class AbstractIntSerializer
    extends TypeSerializer<Integer> {
        private static final long serialVersionUID = 1L;

        public Integer createInstance() {
            return IntSerializer.INSTANCE.createInstance();
        }

        public boolean isImmutableType() {
            return IntSerializer.INSTANCE.isImmutableType();
        }

        public Integer copy(Integer from) {
            return IntSerializer.INSTANCE.copy(from);
        }

        public Integer copy(Integer from, Integer reuse) {
            return IntSerializer.INSTANCE.copy(from, reuse);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            IntSerializer.INSTANCE.copy(source, target);
        }

        public Integer deserialize(DataInputView source) throws IOException {
            return IntSerializer.INSTANCE.deserialize(source);
        }

        public Integer deserialize(Integer reuse, DataInputView source) throws IOException {
            return IntSerializer.INSTANCE.deserialize(reuse, source);
        }

        public void serialize(Integer record, DataOutputView target) throws IOException {
            IntSerializer.INSTANCE.serialize(record, target);
        }

        public TypeSerializer<Integer> duplicate() {
            return IntSerializer.INSTANCE.duplicate();
        }

        public int getLength() {
            return IntSerializer.INSTANCE.getLength();
        }

        public boolean equals(Object obj) {
            return IntSerializer.INSTANCE.equals(obj);
        }

        public int hashCode() {
            return IntSerializer.INSTANCE.hashCode();
        }
    }

    public static class TestConfigSnapshot<T>
    extends TypeSerializerConfigSnapshot<T> {
        static final int VERSION = 1;
        private int val;
        private String msg;

        public TestConfigSnapshot() {
        }

        public TestConfigSnapshot(int val, String msg) {
            this.val = val;
            this.msg = msg;
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeInt(this.val);
            out.writeUTF(this.msg);
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            this.val = in.readInt();
            this.msg = in.readUTF();
        }

        public int getVersion() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof TestConfigSnapshot) {
                return this.val == ((TestConfigSnapshot)((Object)obj)).val && this.msg.equals(((TestConfigSnapshot)((Object)obj)).msg);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.val + this.msg.hashCode();
        }
    }
}

