/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.junit.Assert;
import org.junit.Test;

public class TypeSerializerSnapshotTest {
    @Test
    public void testSerializeConfigWhenSerializerMissing() throws Exception {
        TestSerializer ser = new TestSerializer();
        TypeSerializerConfigSnapshot snap = (TypeSerializerConfigSnapshot)ser.snapshotConfiguration();
        try {
            TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)new DataOutputSerializer(64), (TypeSerializerSnapshot)snap);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSerializerDeserializationFailure() throws Exception {
        TestSerializer ser = new TestSerializer();
        TypeSerializerConfigSnapshot snap = (TypeSerializerConfigSnapshot)ser.snapshotConfiguration();
        snap.setPriorSerializer((TypeSerializer)ser);
        DataOutputSerializer out = new DataOutputSerializer(64);
        TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)snap);
        TypeSerializerSnapshot readBack = TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)new DataInputDeserializer(out.getCopyOfBuffer()), (ClassLoader)this.getClass().getClassLoader());
        Assert.assertNotNull((Object)readBack);
        try {
            readBack.restoreSerializer();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((TypeSerializerConfigSnapshot)readBack).setPriorSerializer((TypeSerializer)new UnloadableDummyTypeSerializer(new byte[0]));
        try {
            readBack.restoreSerializer();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class TestSerializerConfigSnapshot
    extends TypeSerializerConfigSnapshot<Object> {
        public int getVersion() {
            return 0;
        }
    }

    private static final class TestSerializer
    extends TypeSerializer<Object> {
        private final boolean compatible;

        TestSerializer() {
            this(true);
        }

        TestSerializer(boolean compatible) {
            this.compatible = compatible;
        }

        public boolean isImmutableType() {
            throw new UnsupportedOperationException();
        }

        public TypeSerializer<Object> duplicate() {
            throw new UnsupportedOperationException();
        }

        public Object createInstance() {
            throw new UnsupportedOperationException();
        }

        public Object copy(Object from) {
            throw new UnsupportedOperationException();
        }

        public Object copy(Object from, Object reuse) {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        public void serialize(Object record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(DataInputView source) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(Object reuse, DataInputView source) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestSerializer;
        }

        public int hashCode() {
            return 0;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new IOException("cannot deserialize");
        }

        public TypeSerializerSnapshot<Object> snapshotConfiguration() {
            return new TestSerializerConfigSnapshot();
        }
    }
}

