/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.ClassRelocator;
import org.apache.flink.api.common.typeutils.ThreadContextClassLoader;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public abstract class TypeSerializerUpgradeTestBase<PreviousElementT, UpgradedElementT>
extends TestLogger {
    public static final FlinkVersion CURRENT_VERSION = FlinkVersion.v1_16;
    public static final Set<FlinkVersion> MIGRATION_VERSIONS = FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_11, (FlinkVersion)CURRENT_VERSION);
    private final TestSpecification<PreviousElementT, UpgradedElementT> testSpecification;
    private static final int INITIAL_OUTPUT_BUFFER_SIZE = 64;

    protected TypeSerializerUpgradeTestBase(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        this.testSpecification = (TestSpecification)Preconditions.checkNotNull(testSpecification);
    }

    @Test
    @Ignore
    public void generateTestSetupFiles() throws Exception {
        Files.createDirectories(this.getSerializerSnapshotFilePath().getParent(), new FileAttribute[0]);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).setup.setupClassloader);){
            TypeSerializer priorSerializer = ((TestSpecification)this.testSpecification).setup.createPriorSerializer();
            DataOutputSerializer testDataOut = new DataOutputSerializer(64);
            priorSerializer.serialize(((TestSpecification)this.testSpecification).setup.createTestData(), (DataOutputView)testDataOut);
            TypeSerializerUpgradeTestBase.writeContentsTo(this.getGenerateDataFilePath(), testDataOut.getCopyOfBuffer());
            DataOutputSerializer serializerSnapshotOut = new DataOutputSerializer(64);
            TypeSerializerUpgradeTestBase.writeSerializerSnapshot((DataOutputView)serializerSnapshotOut, priorSerializer, CURRENT_VERSION);
            TypeSerializerUpgradeTestBase.writeContentsTo(this.getGenerateSerializerSnapshotFilePath(), serializerSnapshotOut.getCopyOfBuffer());
        }
    }

    @Test
    public void restoreSerializerIsValid() throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).verifier.verifierClassloader);){
            Assume.assumeThat((String)"This test only applies for test specifications that verify an upgraded serializer that is not incompatible.", (Object)TypeSerializerSchemaCompatibility.incompatible(), (Matcher)CoreMatchers.not(((TestSpecification)this.testSpecification).verifier.schemaCompatibilityMatcher(((TestSpecification)this.testSpecification).flinkVersion)));
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest();
            TypeSerializer restoredSerializer = restoredSerializerSnapshot.restoreSerializer();
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(restoredSerializer, this.dataUnderTest(), ((TestSpecification)this.testSpecification).verifier.testDataMatcher());
        }
    }

    @Test
    public void upgradedSerializerHasExpectedSchemaCompatibility() throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest();
            TypeSerializer upgradedSerializer = ((TestSpecification)this.testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            Assert.assertThat((Object)upgradeCompatibility, ((TestSpecification)this.testSpecification).verifier.schemaCompatibilityMatcher(((TestSpecification)this.testSpecification).flinkVersion));
        }
    }

    @Test
    public void upgradedSerializerIsValidAfterMigration() throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest();
            TypeSerializer upgradedSerializer = ((TestSpecification)this.testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            Assume.assumeThat((String)"This test only applies for test specifications that verify an upgraded serializer that requires migration to be compatible.", (Object)upgradeCompatibility, TypeSerializerMatchers.isCompatibleAfterMigration());
            TypeSerializer restoreSerializer = restoredSerializerSnapshot.restoreSerializer();
            DataInputView migratedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(this.dataUnderTest(), restoreSerializer, upgradedSerializer, ((TestSpecification)this.testSpecification).verifier.testDataMatcher());
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(upgradedSerializer, migratedData, ((TestSpecification)this.testSpecification).verifier.testDataMatcher());
        }
    }

    @Test
    public void upgradedSerializerIsValidAfterReconfiguration() throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest();
            TypeSerializer upgradedSerializer = ((TestSpecification)this.testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            Assume.assumeThat((String)"This test only applies for test specifications that verify an upgraded serializer that requires reconfiguration to be compatible.", (Object)upgradeCompatibility, TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer());
            TypeSerializer reconfiguredUpgradedSerializer = upgradeCompatibility.getReconfiguredSerializer();
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(reconfiguredUpgradedSerializer, this.dataUnderTest(), ((TestSpecification)this.testSpecification).verifier.testDataMatcher());
        }
    }

    @Test
    public void upgradedSerializerIsValidWhenCompatibleAsIs() throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)this.testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest();
            TypeSerializer upgradedSerializer = ((TestSpecification)this.testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            Assume.assumeThat((String)"This test only applies for test specifications that verify an upgraded serializer that is compatible as is.", (Object)upgradeCompatibility, TypeSerializerMatchers.isCompatibleAsIs());
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(upgradedSerializer, this.dataUnderTest(), ((TestSpecification)this.testSpecification).verifier.testDataMatcher());
        }
    }

    private static <T> void assertSerializerIsValid(TypeSerializer<T> serializer, DataInputView dataInput, Matcher<T> testDataMatcher) throws Exception {
        DataInputView serializedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(dataInput, serializer, serializer, testDataMatcher);
        TypeSerializerSnapshot<T> snapshot = TypeSerializerUpgradeTestBase.writeAndThenReadSerializerSnapshot(serializer);
        TypeSerializer restoreSerializer = snapshot.restoreSerializer();
        serializedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(serializedData, restoreSerializer, restoreSerializer, testDataMatcher);
        TypeSerializer duplicateSerializer = snapshot.restoreSerializer().duplicate();
        TypeSerializerUpgradeTestBase.readAndThenWriteData(serializedData, duplicateSerializer, duplicateSerializer, testDataMatcher);
    }

    private Path getGenerateSerializerSnapshotFilePath() {
        return Paths.get(this.getGenerateResourceDirectory() + "/serializer-snapshot", new String[0]);
    }

    private Path getGenerateDataFilePath() {
        return Paths.get(this.getGenerateResourceDirectory() + "/test-data", new String[0]);
    }

    private String getGenerateResourceDirectory() {
        return System.getProperty("user.dir") + "/src/test/resources/" + ((TestSpecification)this.testSpecification).name + "-" + CURRENT_VERSION;
    }

    private Path getSerializerSnapshotFilePath() {
        return Paths.get(this.getTestResourceDirectory() + "/serializer-snapshot", new String[0]);
    }

    private Path getTestDataFilePath() {
        return Paths.get(this.getTestResourceDirectory() + "/test-data", new String[0]);
    }

    private String getTestResourceDirectory() {
        return System.getProperty("user.dir") + "/src/test/resources/" + ((TestSpecification)this.testSpecification).name + "-" + ((TestSpecification)this.testSpecification).flinkVersion;
    }

    private TypeSerializerSnapshot<UpgradedElementT> snapshotUnderTest() throws Exception {
        return TypeSerializerUpgradeTestBase.readSerializerSnapshot(TypeSerializerUpgradeTestBase.contentsOf(this.getSerializerSnapshotFilePath()), ((TestSpecification)this.testSpecification).flinkVersion);
    }

    private DataInputView dataUnderTest() {
        return TypeSerializerUpgradeTestBase.contentsOf(this.getTestDataFilePath());
    }

    private static void writeContentsTo(Path path, byte[] bytes) {
        try {
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to " + path, e);
        }
    }

    private static DataInputView contentsOf(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new DataInputDeserializer(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read contents of " + path, e);
        }
    }

    private static <T> void writeSerializerSnapshot(DataOutputView out, TypeSerializer<T> serializer, FlinkVersion flinkVersion) throws IOException {
        if (flinkVersion.isNewerVersionThan(FlinkVersion.v1_6)) {
            TypeSerializerUpgradeTestBase.writeSerializerSnapshotCurrentFormat(out, serializer);
        } else {
            TypeSerializerUpgradeTestBase.writeSerializerSnapshotPre17Format(out, serializer);
        }
    }

    private static <T> void writeSerializerSnapshotCurrentFormat(DataOutputView out, TypeSerializer<T> serializer) throws IOException {
        TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)out, (TypeSerializerSnapshot)serializer.snapshotConfiguration(), serializer);
    }

    private static <T> void writeSerializerSnapshotPre17Format(DataOutputView out, TypeSerializer<T> serializer) throws IOException {
        TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Collections.singletonList(Tuple2.of(serializer, (Object)serializer.snapshotConfiguration())));
    }

    private static <T> TypeSerializerSnapshot<T> readSerializerSnapshot(DataInputView in, FlinkVersion flinkVersion) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (flinkVersion.isNewerVersionThan(FlinkVersion.v1_6)) {
            return TypeSerializerUpgradeTestBase.readSerializerSnapshotCurrentFormat(in, classLoader);
        }
        return TypeSerializerUpgradeTestBase.readSerializerSnapshotPre17Format(in, classLoader);
    }

    private static <T> TypeSerializerSnapshot<T> readSerializerSnapshotCurrentFormat(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader, null);
    }

    private static <T> TypeSerializerSnapshot<T> readSerializerSnapshotPre17Format(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        List serializerSnapshotPair = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)userCodeClassLoader);
        return (TypeSerializerSnapshot)((Tuple2)serializerSnapshotPair.get((int)0)).f1;
    }

    private static <T> DataInputView readAndThenWriteData(DataInputView originalDataInput, TypeSerializer<T> readSerializer, TypeSerializer<T> writeSerializer, Matcher<T> testDataMatcher) throws IOException {
        Object data = readSerializer.deserialize(originalDataInput);
        Assert.assertThat((Object)data, testDataMatcher);
        DataOutputSerializer out = new DataOutputSerializer(64);
        writeSerializer.serialize(data, (DataOutputView)out);
        return new DataInputDeserializer(out.wrapAsByteBuffer());
    }

    private static <T> TypeSerializerSnapshot<T> writeAndThenReadSerializerSnapshot(TypeSerializer<T> serializer) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(64);
        TypeSerializerUpgradeTestBase.writeSerializerSnapshotCurrentFormat((DataOutputView)out, serializer);
        DataInputDeserializer in = new DataInputDeserializer(out.wrapAsByteBuffer());
        return TypeSerializerUpgradeTestBase.readSerializerSnapshotCurrentFormat((DataInputView)in, Thread.currentThread().getContextClassLoader());
    }

    public static class TestSpecification<PreviousElementT, UpgradedElementT> {
        private final String name;
        private final FlinkVersion flinkVersion;
        private final ClassLoaderSafePreUpgradeSetup<PreviousElementT> setup;
        private final ClassLoaderSafeUpgradeVerifier<UpgradedElementT> verifier;

        public TestSpecification(String name, FlinkVersion flinkVersion, Class<? extends PreUpgradeSetup<PreviousElementT>> setupClass, Class<? extends UpgradeVerifier<UpgradedElementT>> verifierClass) throws Exception {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.flinkVersion = (FlinkVersion)Preconditions.checkNotNull((Object)flinkVersion);
            this.setup = new ClassLoaderSafePreUpgradeSetup(setupClass);
            this.verifier = new ClassLoaderSafeUpgradeVerifier(verifierClass);
        }

        public String toString() {
            return this.name + " / " + this.flinkVersion;
        }
    }

    private static class ClassLoaderSafeUpgradeVerifier<UpgradedElementT>
    implements UpgradeVerifier<UpgradedElementT> {
        private final UpgradeVerifier<UpgradedElementT> delegateVerifier;
        private final ClassLoader verifierClassloader;

        ClassLoaderSafeUpgradeVerifier(Class<? extends UpgradeVerifier<UpgradedElementT>> delegateVerifierClass) throws Exception {
            Preconditions.checkNotNull(delegateVerifierClass);
            Class relocatedDelegateVerifierClass = ClassRelocator.relocate(delegateVerifierClass);
            this.verifierClassloader = relocatedDelegateVerifierClass.getClassLoader();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                this.delegateVerifier = (UpgradeVerifier)relocatedDelegateVerifierClass.newInstance();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TypeSerializer<UpgradedElementT> createUpgradedSerializer() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                TypeSerializer<UpgradedElementT> typeSerializer = this.delegateVerifier.createUpgradedSerializer();
                return typeSerializer;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating upgraded serializer via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Matcher<UpgradedElementT> testDataMatcher() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                Matcher<UpgradedElementT> matcher = this.delegateVerifier.testDataMatcher();
                return matcher;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating expected test data via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> schemaCompatibilityMatcher(FlinkVersion version) {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> matcher = this.delegateVerifier.schemaCompatibilityMatcher(version);
                return matcher;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating schema compatibility matcher via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }
    }

    private static class ClassLoaderSafePreUpgradeSetup<PreviousElementT>
    implements PreUpgradeSetup<PreviousElementT> {
        private final PreUpgradeSetup<PreviousElementT> delegateSetup;
        private final ClassLoader setupClassloader;

        ClassLoaderSafePreUpgradeSetup(Class<? extends PreUpgradeSetup<PreviousElementT>> delegateSetupClass) throws Exception {
            Preconditions.checkNotNull(delegateSetupClass);
            Class relocatedDelegateSetupClass = ClassRelocator.relocate(delegateSetupClass);
            this.setupClassloader = relocatedDelegateSetupClass.getClassLoader();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                this.delegateSetup = (PreUpgradeSetup)relocatedDelegateSetupClass.newInstance();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TypeSerializer<PreviousElementT> createPriorSerializer() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                TypeSerializer<PreviousElementT> typeSerializer = this.delegateSetup.createPriorSerializer();
                return typeSerializer;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating prior serializer via ClassLoaderSafePreUpgradeSetup.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public PreviousElementT createTestData() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                PreviousElementT PreviousElementT = this.delegateSetup.createTestData();
                return PreviousElementT;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating test data via ThreadContextClassLoader.", e);
            }
        }
    }

    public static interface UpgradeVerifier<UpgradedElementT> {
        public TypeSerializer<UpgradedElementT> createUpgradedSerializer();

        public Matcher<UpgradedElementT> testDataMatcher();

        public Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> schemaCompatibilityMatcher(FlinkVersion var1);
    }

    public static interface PreUpgradeSetup<PreviousElementT> {
        public TypeSerializer<PreviousElementT> createPriorSerializer();

        public PreviousElementT createTestData();
    }
}

