/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.ClassRelocator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.TestEnum;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnumSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TestEnum, TestEnum> {
    private static final String SPEC_NAME = "enum-serializer";

    public EnumSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<TestEnum, TestEnum> enumSerializer) {
        super(enumSerializer);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, EnumSerializerSetup.class, EnumSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("enum-serializerreconfig", flinkVersion, EnumSerializerReconfigSetup.class, EnumSerializerReconfigVerifier.class));
        }
        return testSpecifications;
    }

    private static Matcher<? extends TypeSerializer<TestEnum>> enumSerializerWith(final TestEnum[] expectedEnumValues) {
        return new TypeSafeMatcher<EnumSerializer<TestEnum>>(){

            protected boolean matchesSafely(EnumSerializer<TestEnum> reconfiguredSerialized) {
                return Arrays.equals(reconfiguredSerialized.getValues(), (Object[])expectedEnumValues);
            }

            public void describeTo(Description description) {
                description.appendText("EnumSerializer with values ").appendValueList("{", ", ", "}", (Object[])expectedEnumValues);
            }
        };
    }

    public static final class EnumSerializerReconfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<EnumAfter> {
        @Override
        public TypeSerializer<EnumAfter> createUpgradedSerializer() {
            return new EnumSerializer(EnumAfter.class);
        }

        @Override
        public Matcher<EnumAfter> testDataMatcher() {
            return Matchers.is((Object)((Object)EnumAfter.EMMA));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<EnumAfter>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }

        @ClassRelocator.RelocateClass(value="TestEnumSerializerReconfig")
        public static enum EnumAfter {
            FOO,
            BAR,
            PETER,
            PAULA,
            NATHANIEL,
            EMMA;

        }
    }

    public static final class EnumSerializerReconfigSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<EnumBefore> {
        @Override
        public TypeSerializer<EnumBefore> createPriorSerializer() {
            return new EnumSerializer(EnumBefore.class);
        }

        @Override
        public EnumBefore createTestData() {
            return EnumBefore.EMMA;
        }

        @ClassRelocator.RelocateClass(value="TestEnumSerializerReconfig")
        public static enum EnumBefore {
            FOO,
            BAR,
            PETER,
            NATHANIEL,
            EMMA,
            PAULA;

        }
    }

    public static final class EnumSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TestEnum> {
        @Override
        public TypeSerializer<TestEnum> createUpgradedSerializer() {
            return new EnumSerializer(TestEnum.class);
        }

        @Override
        public Matcher<TestEnum> testDataMatcher() {
            return Matchers.is((Object)((Object)TestEnum.EMMA));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<TestEnum>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class EnumSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TestEnum> {
        @Override
        public TypeSerializer<TestEnum> createPriorSerializer() {
            return new EnumSerializer(TestEnum.class);
        }

        @Override
        public TestEnum createTestData() {
            return TestEnum.EMMA;
        }
    }
}

