/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.junit.Assert;
import org.junit.Test;

public class TypeExtractorInputFormatsTest {
    @Test
    public void testExtractInputFormatType() {
        try {
            DummyFloatInputFormat format = new DummyFloatInputFormat();
            TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
            Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)typeInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractDerivedInputFormatType() {
        try {
            GenericInputFormat format = new DerivedInputFormat();
            TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
            Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)typeInfo);
            format = new DerivedTupleInputFormat();
            typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
            Assert.assertTrue((boolean)typeInfo.isTupleType());
            Assert.assertTrue((boolean)(typeInfo instanceof TupleTypeInfo));
            TupleTypeInfo tupleInfo = (TupleTypeInfo)typeInfo;
            Assert.assertEquals((long)3L, (long)tupleInfo.getArity());
            Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tupleInfo.getTypeAt(0));
            Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)tupleInfo.getTypeAt(1));
            Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tupleInfo.getTypeAt(2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMultiLevelDerivedInputFormatType() {
        try {
            FinalRelativeInputFormat format = new FinalRelativeInputFormat();
            TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
            Assert.assertTrue((boolean)typeInfo.isTupleType());
            Assert.assertTrue((boolean)(typeInfo instanceof TupleTypeInfo));
            TupleTypeInfo tupleInfo = (TupleTypeInfo)typeInfo;
            Assert.assertEquals((long)3L, (long)tupleInfo.getArity());
            Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tupleInfo.getTypeAt(0));
            Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tupleInfo.getTypeAt(1));
            Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tupleInfo.getTypeAt(2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryableFormatType() {
        try {
            QueryableInputFormat format = new QueryableInputFormat();
            TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
            Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)typeInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static final class QueryableInputFormat
    implements InputFormat<Float, InputSplit>,
    ResultTypeQueryable<Double> {
        public void configure(Configuration parameters) {
        }

        public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
            return null;
        }

        public InputSplit[] createInputSplits(int minNumSplits) {
            return null;
        }

        public DefaultInputSplitAssigner getInputSplitAssigner(InputSplit[] splits) {
            return null;
        }

        public void open(InputSplit split) {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Float nextRecord(Float reuse) throws IOException {
            return null;
        }

        public void close() {
        }

        public TypeInformation<Double> getProducedType() {
            return BasicTypeInfo.DOUBLE_TYPE_INFO;
        }
    }

    public static final class FinalRelativeInputFormat
    extends RelativeInputFormat<Integer> {
        @Override
        public Tuple3<String, Integer, Double> nextRecord(Tuple3<String, Integer, Double> reuse) {
            return null;
        }
    }

    public static class RelativeInputFormat<T>
    extends GenericInputFormat<Tuple3<String, T, Double>> {
        public boolean reachedEnd() {
            return false;
        }

        public Tuple3<String, T, Double> nextRecord(Tuple3<String, T, Double> reuse) {
            return null;
        }
    }

    public static final class DerivedTupleInputFormat
    extends GenericInputFormat<Tuple3<String, Short, Double>> {
        public boolean reachedEnd() {
            return false;
        }

        public Tuple3<String, Short, Double> nextRecord(Tuple3<String, Short, Double> reuse) {
            return null;
        }
    }

    public static final class DerivedInputFormat
    extends GenericInputFormat<Short> {
        public boolean reachedEnd() {
            return false;
        }

        public Short nextRecord(Short reuse) {
            return null;
        }
    }

    public static final class DummyFloatInputFormat
    implements InputFormat<Float, InputSplit> {
        public void configure(Configuration parameters) {
        }

        public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
            return null;
        }

        public InputSplit[] createInputSplits(int minNumSplits) {
            return null;
        }

        public DefaultInputSplitAssigner getInputSplitAssigner(InputSplit[] splits) {
            return null;
        }

        public void open(InputSplit split) {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Float nextRecord(Float reuse) throws IOException {
            return null;
        }

        public void close() {
        }
    }
}

