/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Test;

public class MultidimensionalArraySerializerTest {
    @Test
    public void testStringArray() {
        String[][] array = new String[][]{{null, "b"}, {"c", "d"}, {"e", "f"}, {"g", "h"}, null};
        TypeInformation ti = TypeExtractor.getForClass(String[][].class);
        SerializerTestInstance<String[][]> testInstance = new SerializerTestInstance<String[][]>(ti.createSerializer(new ExecutionConfig()), String[][].class, -1, (String[][][])new String[][][]{array}){};
        testInstance.testAll();
    }

    @Test
    public void testPrimitiveArray() {
        int[][] array = new int[][]{{12, 1}, {48, 42}, {23, 80}, {484, 849}, {987, 4}};
        TypeInformation ti = TypeExtractor.getForClass(int[][].class);
        SerializerTestInstance<int[][]> testInstance = new SerializerTestInstance<int[][]>(ti.createSerializer(new ExecutionConfig()), int[][].class, -1, (int[][][])new int[][][]{array}){};
        testInstance.testAll();
    }

    @Test
    public void testObjectArrays() {
        Integer[][] array = new Integer[][]{{0, 1}, null, {null, 42}};
        TypeInformation ti = TypeExtractor.getForClass(Integer[][].class);
        SerializerTestInstance<Integer[][]> testInstance = new SerializerTestInstance<Integer[][]>(ti.createSerializer(new ExecutionConfig()), Integer[][].class, -1, (Integer[][][])new Integer[][][]{array}){};
        testInstance.testAll();
        MyPojo[][] array2 = new MyPojo[][]{{new MyPojo(null, 42), new MyPojo("test2", -1)}, {null, null}, null};
        TypeInformation ti2 = TypeExtractor.getForClass(MyPojo[][].class);
        SerializerTestInstance<MyPojo[][]> testInstance2 = new SerializerTestInstance<MyPojo[][]>(ti2.createSerializer(new ExecutionConfig()), MyPojo[][].class, -1, (MyPojo[][][])new MyPojo[][][]{array2}){};
        testInstance2.testAll();
    }

    @Test
    public void testGenericObjectArrays() {
        MyGenericPojo[][] array = new MyGenericPojo[][]{{new MyGenericPojo<String>(new String[][]{{"a", "b"}, {"c", "d"}}), null}};
        TypeInformation ti = TypeInformation.of((TypeHint)new TypeHint<MyGenericPojo<String>[][]>(){});
        SerializerTestInstance testInstance = new SerializerTestInstance(ti.createSerializer(new ExecutionConfig()), MyGenericPojo[][].class, -1, new Object[]{array}){};
        testInstance.testAll();
    }

    public static class MyGenericPojo<T> {
        public T[][] field;

        public MyGenericPojo() {
        }

        public MyGenericPojo(T[][] field) {
            this.field = field;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyGenericPojo)) {
                return false;
            }
            MyGenericPojo other = (MyGenericPojo)obj;
            return this.field == null && other.field == null || this.field != null && this.field.length == other.field.length;
        }
    }

    public static class MyPojo {
        public String field1;
        public int field2;

        public MyPojo(String field1, int field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyPojo)) {
                return false;
            }
            MyPojo other = (MyPojo)obj;
            return (this.field1 == null && other.field1 == null || this.field1 != null && this.field1.equals(other.field1)) && this.field2 == other.field2;
        }
    }
}

