/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;

class RowComparatorTest
extends ComparatorTestBase<Row> {
    private static final RowTypeInfo typeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.SHORT_TYPE_INFO}), TypeExtractor.createTypeInfo(MyPojo.class)});
    private static MyPojo testPojo1 = new MyPojo();
    private static MyPojo testPojo2 = new MyPojo();
    private static MyPojo testPojo3 = new MyPojo();
    private static final Row[] data = new Row[]{RowComparatorTest.createRow(RowKind.INSERT, null, null, null, null, null), RowComparatorTest.createRow(RowKind.INSERT, 0, null, null, null, null), RowComparatorTest.createRow(RowKind.INSERT, 0, 0.0, null, null, null), RowComparatorTest.createRow(RowKind.INSERT, 0, 0.0, "a", null, null), RowComparatorTest.createRow(RowKind.INSERT, 1, 0.0, "a", null, null), RowComparatorTest.createRow(RowKind.INSERT, 1, 1.0, "a", null, null), RowComparatorTest.createRow(RowKind.INSERT, 1, 1.0, "b", null, null), RowComparatorTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)1, (Object)false, (Object)2), null), RowComparatorTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)false, (Object)2), null), RowComparatorTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)2), null), RowComparatorTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), null), RowComparatorTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo1), RowComparatorTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo2), RowComparatorTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo3)};

    RowComparatorTest() {
    }

    @BeforeAll
    static void init() {
        RowComparatorTest.testPojo1.name = "";
        RowComparatorTest.testPojo2.name = "Test1";
        RowComparatorTest.testPojo3.name = "Test2";
    }

    @Override
    protected void deepEquals(String message, Row should, Row is) {
        int arity = should.getArity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)is.getArity()).as(message, new Object[0])).isEqualTo(arity);
        for (int i = 0; i < arity; ++i) {
            Object copiedValue = should.getField(i);
            Object element = is.getField(i);
            ((ObjectAssert)Assertions.assertThat((Object)element).as(message, new Object[0])).isEqualTo(copiedValue);
        }
    }

    @Override
    protected TypeComparator<Row> createComparator(boolean ascending) {
        return typeInfo.createComparator(new int[]{0, 1, 2, 3, 4, 5, 6}, new boolean[]{ascending, ascending, ascending, ascending, ascending, ascending, ascending}, 0, new ExecutionConfig());
    }

    @Override
    protected TypeSerializer<Row> createSerializer() {
        return typeInfo.createSerializer(new ExecutionConfig());
    }

    protected Row[] getSortedTestData() {
        return data;
    }

    @Override
    protected boolean supportsNullKeys() {
        return true;
    }

    private static Row createRow(RowKind kind, Object f0, Object f1, Object f2, Object f3, Object f4) {
        Row row = new Row(kind, 5);
        row.setField(0, f0);
        row.setField(1, f1);
        row.setField(2, f2);
        row.setField(3, f3);
        row.setField(4, f4);
        return row;
    }

    public static class MyPojo
    implements Serializable,
    Comparable<MyPojo> {
        public String name = "";

        @Override
        public int compareTo(MyPojo o) {
            if (this.name == null && o.name == null) {
                return 0;
            }
            if (this.name == null) {
                return -1;
            }
            if (o.name == null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.name != null ? this.name.equals(myPojo.name) : myPojo.name == null;
        }
    }
}

