/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RowSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Row, Row> {
    public RowSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Row, Row> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        ArrayList<FlinkVersion> testVersions = new ArrayList<FlinkVersion>();
        testVersions.add(FlinkVersion.v1_10);
        testVersions.addAll(MIGRATION_VERSIONS);
        for (FlinkVersion flinkVersion : testVersions) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("row-serializer", flinkVersion, RowSerializerSetup.class, RowSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static TypeSerializer<Row> createRowSerializer() {
        RowTypeInfo rowTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        return rowTypeInfo.createSerializer(new ExecutionConfig());
    }

    public static final class RowSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Row> {
        @Override
        public TypeSerializer<Row> createUpgradedSerializer() {
            return RowSerializerUpgradeTest.createRowSerializer();
        }

        @Override
        public Matcher<Row> testDataMatcher() {
            Row row = new Row(RowKind.INSERT, 4);
            row.setField(0, null);
            row.setField(1, (Object)42L);
            row.setField(2, (Object)"My string.");
            row.setField(3, null);
            return Matchers.is((Object)row);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<Row>> schemaCompatibilityMatcher(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_10)) {
                return TypeSerializerMatchers.isCompatibleAsIs();
            }
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }
    }

    public static final class RowSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Row> {
        @Override
        public TypeSerializer<Row> createPriorSerializer() {
            return RowSerializerUpgradeTest.createRowSerializer();
        }

        @Override
        public Row createTestData() {
            Row row = new Row(4);
            row.setField(0, null);
            row.setField(1, (Object)42L);
            row.setField(2, (Object)"My string.");
            row.setField(3, null);
            return row;
        }
    }
}

