/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TupleSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Tuple3<String, String, Integer>, Tuple3<String, String, Integer>> {
    public TupleSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Tuple3<String, String, Integer>, Tuple3<String, String, Integer>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("tuple-serializer", flinkVersion, TupleSerializerSetup.class, TupleSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class TupleSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Tuple3<String, String, Integer>> {
        @Override
        public TypeSerializer<Tuple3<String, String, Integer>> createUpgradedSerializer() {
            return new TupleSerializer(Tuple3.class, new TypeSerializer[]{StringSerializer.INSTANCE, StringSerializer.INSTANCE, IntSerializer.INSTANCE});
        }

        @Override
        public Matcher<Tuple3<String, String, Integer>> testDataMatcher() {
            return Matchers.is((Object)new Tuple3((Object)"hello Gordon", (Object)"ciao", (Object)14));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<Tuple3<String, String, Integer>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class TupleSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Tuple3<String, String, Integer>> {
        @Override
        public TypeSerializer<Tuple3<String, String, Integer>> createPriorSerializer() {
            return new TupleSerializer(Tuple3.class, new TypeSerializer[]{StringSerializer.INSTANCE, StringSerializer.INSTANCE, IntSerializer.INSTANCE});
        }

        @Override
        public Tuple3<String, String, Integer> createTestData() {
            return new Tuple3((Object)"hello Gordon", (Object)"ciao", (Object)14);
        }
    }
}

