/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;

public class ValueID
implements Value,
Comparable<ValueID> {
    private static final long serialVersionUID = -562791433077971752L;
    private UUID id;

    public ValueID() {
        this.id = UUID.randomUUID();
    }

    public ValueID(UUID id) {
        this.id = id;
    }

    @Override
    public int compareTo(ValueID o) {
        return this.id.compareTo(o.id);
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.id.getMostSignificantBits());
        out.writeLong(this.id.getLeastSignificantBits());
    }

    public void read(DataInputView in) throws IOException {
        this.id = new UUID(in.readLong(), in.readLong());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueID) {
            ValueID other = (ValueID)obj;
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

