/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ValueSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<NameValue, NameValue> {
    public ValueSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<NameValue, NameValue> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("value-serializer", flinkVersion, ValueSerializerSetup.class, ValueSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class NameValue
    implements Value {
        public static final long serialVersionUID = 2277251654485371327L;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeUTF(this.name);
        }

        public void read(DataInputView in) throws IOException {
            this.name = in.readUTF();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NameValue)) {
                return false;
            }
            NameValue other = (NameValue)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    public static final class ValueSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NameValue> {
        @Override
        public TypeSerializer<NameValue> createUpgradedSerializer() {
            return new ValueSerializer(NameValue.class);
        }

        @Override
        public Matcher<NameValue> testDataMatcher() {
            NameValue value = new NameValue();
            value.setName("klion26");
            return Matchers.is((Object)value);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<NameValue>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ValueSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NameValue> {
        @Override
        public TypeSerializer<NameValue> createPriorSerializer() {
            return new ValueSerializer(NameValue.class);
        }

        @Override
        public NameValue createTestData() {
            NameValue value = new NameValue();
            value.setName("klion26");
            return value;
        }
    }
}

