/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KryoSerializerClassLoadingTest
extends SerializerTestBase<Object> {
    private static final ClassLoaderUtils.ObjectAndClassLoader<Serializable> OUTSIDE_CLASS_LOADING = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
    private ClassLoader originalClassLoader;

    KryoSerializerClassLoadingTest() {
    }

    @BeforeEach
    void setupClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OUTSIDE_CLASS_LOADING.getClassLoader());
    }

    @AfterEach
    void restoreOriginalClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    void guardTestAssumptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Class.forName(OUTSIDE_CLASS_LOADING.getObject().getClass().getName())).isInstanceOf(ClassNotFoundException.class)).withFailMessage("This test's assumptions are broken", new Object[0]);
    }

    @Override
    protected TypeSerializer<Object> createSerializer() {
        return new KryoSerializer(Object.class, new ExecutionConfig());
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<Object> getTypeClass() {
        return Object.class;
    }

    @Override
    protected Object[] getTestData() {
        return new Object[]{new Integer(7), OUTSIDE_CLASS_LOADING.getObject(), new Tuple1((Object)OUTSIDE_CLASS_LOADING.getObject())};
    }

    @Override
    public void testInstantiate() {
    }
}

