/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class SerializersTest {
    @Test
    public void testTypeRegistration() {
        ExecutionConfig conf = new ExecutionConfig();
        Serializers.recursivelyRegisterType(ClassWithNested.class, (ExecutionConfig)conf, new HashSet());
        KryoSerializer kryo = new KryoSerializer(String.class, conf);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromNested.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(ClassWithNested.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(Path.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromGeneric1.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromGeneric2.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(Node.class).getId() > 0 ? 1 : 0) != 0);
        ExecutionConfig conf2 = new ExecutionConfig();
        Serializers.recursivelyRegisterType(ClassWithNested.class, (ExecutionConfig)conf2, new HashSet());
        KryoSerializer kryo2 = new KryoSerializer(String.class, conf);
        Assert.assertTrue((kryo2.getKryo().getRegistration(FromNested.class).getId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTypeRegistrationFromTypeInfo() {
        ExecutionConfig conf = new ExecutionConfig();
        Serializers.recursivelyRegisterType((TypeInformation)new GenericTypeInfo(ClassWithNested.class), (ExecutionConfig)conf, new HashSet());
        KryoSerializer kryo = new KryoSerializer(String.class, conf);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromNested.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(ClassWithNested.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(Path.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromGeneric1.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(FromGeneric2.class).getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((kryo.getKryo().getRegistration(Node.class).getId() > 0 ? 1 : 0) != 0);
    }

    public static class ClassWithNested {
        Nested1 nested;
        int ab;
        ArrayList<FromGeneric1> addGenType;
        FromGeneric2[] genericArrayType;
    }

    public static class Nested1 {
        private FromNested fromNested;
        private Path yodaInterval;
    }

    public static class FromGeneric2 {
    }

    public static class FromGeneric1 {
    }

    public static class FromNested {
        Node recurseMe;
    }

    public static class Node {
        private Node parent;
    }
}

