/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.shaded.guava30.com.google.common.collect.Sets;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ConfigOptionTest
extends TestLogger {
    @Test
    public void testDeprecationFlagForDeprecatedKeys() {
        ConfigOption optionWithDeprecatedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"});
        Assert.assertTrue((boolean)optionWithDeprecatedKeys.hasFallbackKeys());
        for (FallbackKey fallbackKey : optionWithDeprecatedKeys.fallbackKeys()) {
            Assert.assertTrue((String)"deprecated key not flagged as deprecated", (boolean)fallbackKey.isDeprecated());
        }
    }

    @Test
    public void testDeprecationFlagForFallbackKeys() {
        ConfigOption optionWithFallbackKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        Assert.assertTrue((boolean)optionWithFallbackKeys.hasFallbackKeys());
        for (FallbackKey fallbackKey : optionWithFallbackKeys.fallbackKeys()) {
            Assert.assertFalse((String)"falback key flagged as deprecated", (boolean)fallbackKey.isDeprecated());
        }
    }

    @Test
    public void testDeprecationFlagForMixedAlternativeKeys() {
        ConfigOption optionWithMixedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"}).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        ArrayList<String> fallbackKeys = new ArrayList<String>(2);
        ArrayList<String> deprecatedKeys = new ArrayList<String>(2);
        for (FallbackKey alternativeKey : optionWithMixedKeys.fallbackKeys()) {
            if (alternativeKey.isDeprecated()) {
                deprecatedKeys.add(alternativeKey.getKey());
                continue;
            }
            fallbackKeys.add(alternativeKey.getKey());
        }
        Assert.assertEquals((long)2L, (long)fallbackKeys.size());
        Assert.assertEquals((long)2L, (long)deprecatedKeys.size());
        Assert.assertThat(fallbackKeys, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fallback1", "fallback2"}));
        Assert.assertThat(deprecatedKeys, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"deprecated1", "deprecated2"}));
    }

    @Test
    public void testDeprecationForDeprecatedKeys() {
        String[] deprecatedKeys = new String[]{"deprecated1", "deprecated2"};
        HashSet<String> expectedDeprecatedKeys = new HashSet<String>(Arrays.asList(deprecatedKeys));
        ConfigOption optionWithDeprecatedKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(deprecatedKeys).withFallbackKeys(new String[]{"fallback1"});
        Assert.assertTrue((boolean)optionWithDeprecatedKeys.hasDeprecatedKeys());
        Assert.assertEquals(expectedDeprecatedKeys, (Object)Sets.newHashSet((Iterable)optionWithDeprecatedKeys.deprecatedKeys()));
    }

    @Test
    public void testNoDeprecationForFallbackKeysWithoutDeprecated() {
        ConfigOption optionWithFallbackKeys = ConfigOptions.key((String)"key").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"fallback1"});
        Assert.assertFalse((boolean)optionWithFallbackKeys.hasDeprecatedKeys());
    }
}

