/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class ConfigUtilsTest {
    private static final ConfigOption<List<String>> TEST_OPTION = ConfigOptions.key((String)"test.option.key").stringType().asList().noDefaultValue();
    private static final Integer[] intArray = new Integer[]{1, 3, 2, 4};
    private static final List<Integer> intList = Arrays.asList(intArray);

    @Test
    public void collectionIsCorrectlyPutAndFetched() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, intList, Object::toString);
        List recovered = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recovered, (Matcher)IsEqual.equalTo(intList));
    }

    @Test
    public void arrayIsCorrectlyPutAndFetched() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, (Object[])intArray, Object::toString);
        List recovered = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recovered, (Matcher)IsEqual.equalTo(intList));
    }

    @Test
    public void nullCollectionPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, null, Object::toString);
        Assert.assertThat((Object)configurationUnderTest.keySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Object recovered = configurationUnderTest.get(TEST_OPTION);
        Assert.assertThat((Object)recovered, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recoveredList, (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void nullArrayPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, null, Object::toString);
        Assert.assertThat((Object)configurationUnderTest.keySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Object recovered = configurationUnderTest.get(TEST_OPTION);
        Assert.assertThat((Object)recovered, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recoveredList, (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void emptyCollectionPutsEmptyValueInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, Collections.emptyList(), Object::toString);
        List recovered = (List)configurationUnderTest.get(TEST_OPTION);
        Assert.assertThat((Object)recovered, (Matcher)Is.is((Matcher)Matchers.empty()));
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recoveredList, (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void emptyArrayPutsEmptyValueInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, (Object[])new Integer[5], Object::toString);
        List recovered = (List)configurationUnderTest.get(TEST_OPTION);
        Assert.assertThat((Object)recovered, (Matcher)Is.is((Matcher)Matchers.empty()));
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assert.assertThat((Object)recoveredList, (Matcher)Is.is((Matcher)Matchers.empty()));
    }
}

