/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GlobalConfigurationTest
extends TestLogger {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationYAML() {
        File tmpDir = this.tempFolder.getRoot();
        File confFile = new File(tmpDir, "flink-conf.yaml");
        try {
            try (PrintWriter pw = new PrintWriter(confFile);){
                pw.println("###########################");
                pw.println("# Some : comments : to skip");
                pw.println("###########################");
                pw.println("mykey1: myvalue1");
                pw.println("mykey2       : myvalue2");
                pw.println("mykey3:myvalue3");
                pw.println(" some nonsense without colon and whitespace separator");
                pw.println(" :  ");
                pw.println("   ");
                pw.println(" ");
                pw.println("mykey4: myvalue4# some comments");
                pw.println("   mykey5    :    myvalue5    ");
                pw.println("mykey6: my: value6");
                pw.println("mykey7: ");
                pw.println(": myvalue8");
                pw.println("mykey9: myvalue9");
                pw.println("mykey9: myvalue10");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            Configuration conf = GlobalConfiguration.loadConfiguration((String)tmpDir.getAbsolutePath());
            Assert.assertEquals((long)6L, (long)conf.keySet().size());
            Assert.assertEquals((Object)"myvalue1", (Object)conf.getString("mykey1", null));
            Assert.assertEquals((Object)"myvalue2", (Object)conf.getString("mykey2", null));
            Assert.assertEquals((Object)"null", (Object)conf.getString("mykey3", "null"));
            Assert.assertEquals((Object)"myvalue4", (Object)conf.getString("mykey4", null));
            Assert.assertEquals((Object)"myvalue5", (Object)conf.getString("mykey5", null));
            Assert.assertEquals((Object)"my: value6", (Object)conf.getString("mykey6", null));
            Assert.assertEquals((Object)"null", (Object)conf.getString("mykey7", "null"));
            Assert.assertEquals((Object)"null", (Object)conf.getString("mykey8", "null"));
            Assert.assertEquals((Object)"myvalue10", (Object)conf.getString("mykey9", null));
        }
        finally {
            confFile.delete();
            tmpDir.delete();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailIfNull() {
        GlobalConfiguration.loadConfiguration((String)null);
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testFailIfNotLoaded() {
        GlobalConfiguration.loadConfiguration((String)("/some/path/" + UUID.randomUUID()));
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testInvalidConfiguration() throws IOException {
        GlobalConfiguration.loadConfiguration((String)this.tempFolder.getRoot().getAbsolutePath());
    }

    @Test
    public void testInvalidYamlFile() throws IOException {
        File confFile = this.tempFolder.newFile("flink-conf.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.append("invalid");
        }
        Assert.assertNotNull((Object)GlobalConfiguration.loadConfiguration((String)this.tempFolder.getRoot().getAbsolutePath()));
    }

    @Test
    public void testHiddenKey() {
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"password123"));
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"123pasSword"));
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"PasSword"));
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"Secret"));
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"fs.azure.account.key.storageaccount123456.core.windows.net"));
        Assert.assertFalse((boolean)GlobalConfiguration.isSensitive((String)"Hello"));
        Assert.assertTrue((boolean)GlobalConfiguration.isSensitive((String)"metrics.reporter.dghttp.apikey"));
    }
}

