/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReadableWritableConfigurationTest {
    @Parameterized.Parameter
    public TestSpec<?> testSpec;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec<?>> getSpecs() {
        return Arrays.asList(new TestSpec<Integer>(ConfigOptions.key((String)"int").intType().defaultValue((Object)-1)).valueEquals(12345, "12345").checkDefaultOverride(5), new TestSpec<Long>(ConfigOptions.key((String)"long").longType().defaultValue((Object)-1L)).valueEquals(12345L, "12345").checkDefaultOverride(5L), new TestSpec<Float>(ConfigOptions.key((String)"float").floatType().defaultValue((Object)Float.valueOf(0.01f))).valueEquals(Float.valueOf(0.003f), "0.003").checkDefaultOverride(Float.valueOf(1.23f)), new TestSpec<Double>(ConfigOptions.key((String)"double").doubleType().defaultValue((Object)0.01)).valueEquals(0.003, "0.003").checkDefaultOverride(1.23), new TestSpec<Boolean>(ConfigOptions.key((String)"boolean").booleanType().defaultValue((Object)false)).valueEquals(true, "true").checkDefaultOverride(true), new TestSpec<List<Integer>>(ConfigOptions.key((String)"list<int>").intType().asList().defaultValues((Object[])new Integer[]{-1, 2, 3})).valueEquals(Arrays.asList(1, 2, 3, 4, 5), "1;2;3;4;5").checkDefaultOverride(Arrays.asList(1, 2)), new TestSpec<List<String>>(ConfigOptions.key((String)"list<string>").stringType().asList().defaultValues((Object[])new String[]{"A", "B", "C"})).valueEquals(Arrays.asList("A;B", "C"), "'A;B';C").checkDefaultOverride(Collections.singletonList("C")), new TestSpec<Duration>(ConfigOptions.key((String)"interval").durationType().defaultValue((Object)Duration.ofHours(3L))).valueEquals(Duration.ofMinutes(3L), "3 min").checkDefaultOverride(Duration.ofSeconds(1L)), new TestSpec<MemorySize>(ConfigOptions.key((String)"memory").memoryType().defaultValue((Object)new MemorySize(1024L))).valueEquals(new MemorySize(0x40000000L), "1g").checkDefaultOverride(new MemorySize(2048L)), new TestSpec<Map<String, String>>(ConfigOptions.key((String)"properties").mapType().defaultValue(ReadableWritableConfigurationTest.asMap(Collections.singletonList(Tuple2.of((Object)"prop1", (Object)"value1"))))).valueEquals(ReadableWritableConfigurationTest.asMap(Arrays.asList(Tuple2.of((Object)"key1", (Object)"value1"), Tuple2.of((Object)"key2", (Object)"value2"))), "key1:value1,key2:value2").checkDefaultOverride(Collections.emptyMap()), new TestSpec<List<Map>>(ConfigOptions.key((String)"list<properties>").mapType().asList().defaultValues((Object[])new Map[]{ReadableWritableConfigurationTest.asMap(Collections.singletonList(Tuple2.of((Object)"prop1", (Object)"value1")))})).valueEquals(Arrays.asList(ReadableWritableConfigurationTest.asMap(Arrays.asList(Tuple2.of((Object)"key1", (Object)"value1"), Tuple2.of((Object)"key2", (Object)"value2"))), ReadableWritableConfigurationTest.asMap(Arrays.asList(Tuple2.of((Object)"key3", (Object)"value3")))), "key1:value1,key2:value2;key3:value3").checkDefaultOverride(Collections.emptyList()));
    }

    private static Map<String, String> asMap(List<Tuple2<String, String>> entries) {
        return entries.stream().collect(Collectors.toMap(t -> (String)t.f0, t -> (String)t.f1));
    }

    @Test
    public void testGetOptionalFromObject() {
        Configuration configuration = new Configuration();
        this.testSpec.setValue(configuration);
        Optional optional = configuration.getOptional(this.testSpec.getOption());
        Assert.assertThat(optional.get(), (Matcher)CoreMatchers.equalTo(this.testSpec.getValue()));
    }

    @Test
    public void testGetOptionalFromString() {
        ConfigOption<?> option = this.testSpec.getOption();
        Configuration configuration = new Configuration();
        configuration.setString(option.key(), this.testSpec.getStringValue());
        Optional optional = configuration.getOptional(option);
        Assert.assertThat(optional.get(), (Matcher)CoreMatchers.equalTo(this.testSpec.getValue()));
    }

    @Test
    public void testGetDefaultValue() {
        Configuration configuration = new Configuration();
        ConfigOption<?> option = this.testSpec.getOption();
        Object value = configuration.get(option);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)option.defaultValue()));
    }

    @Test
    public void testGetOptionalDefaultValueOverride() {
        Configuration configuration = new Configuration();
        ConfigOption<?> option = this.testSpec.getOption();
        Object value = configuration.getOptional(option).orElse(this.testSpec.getDefaultValueOverride());
        Assert.assertThat(value, (Matcher)CoreMatchers.equalTo(this.testSpec.getDefaultValueOverride()));
    }

    private static class TestSpec<T> {
        private final ConfigOption<T> option;
        private T value;
        private String stringValue;
        private T defaultValueOverride;

        private TestSpec(ConfigOption<T> option) {
            this.option = option;
        }

        public TestSpec<T> valueEquals(T objectValue, String stringValue) {
            this.value = objectValue;
            this.stringValue = stringValue;
            return this;
        }

        public TestSpec<T> checkDefaultOverride(T defaultValueOverride) {
            Preconditions.checkArgument((!Objects.equals(defaultValueOverride, this.option.defaultValue()) ? 1 : 0) != 0, (Object)"Default value override should be different from the config option default.");
            this.defaultValueOverride = defaultValueOverride;
            return this;
        }

        public ConfigOption<T> getOption() {
            return this.option;
        }

        public T getValue() {
            return this.value;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public T getDefaultValueOverride() {
            return this.defaultValueOverride;
        }

        public void setValue(Configuration configuration) {
            configuration.set(this.option, this.value);
        }

        public String toString() {
            return "TestSpec{option=" + this.option + ", value=" + this.value + ", stringValue='" + this.stringValue + '\'' + ", defaultValueOverride=" + this.defaultValueOverride + '}';
        }
    }
}

