/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.EntropyInjector;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.OutputStreamAndPath;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.PluginFileSystemFactory;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EntropyInjectorTest {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();

    @Test
    public void testEmptyPath() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("test", "ignored");
        Path path = new Path("hdfs://localhost:12345");
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testFullUriNonMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "ignored");
        Path path = new Path("s3://hugo@myawesomehost:55522/path/to/the/file");
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testFullUriMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("s0mek3y", "12345678");
        Path path = new Path("s3://hugo@myawesomehost:55522/path/s0mek3y/the/file");
        Assert.assertEquals((Object)new Path("s3://hugo@myawesomehost:55522/path/12345678/the/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)new Path("s3://hugo@myawesomehost:55522/path/the/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testPathOnlyNonMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "ignored");
        Path path = new Path("/path/file");
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)path, (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testPathOnlyMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "xyzz");
        Path path = new Path("/path/_entropy_key_/file");
        Assert.assertEquals((Object)new Path("/path/xyzz/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)new Path("/path/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testEntropyNotFullSegment() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "pqr");
        Path path = new Path("s3://myhost:122/entropy-_entropy_key_-suffix/file");
        Assert.assertEquals((Object)new Path("s3://myhost:122/entropy-pqr-suffix/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true));
        Assert.assertEquals((Object)new Path("s3://myhost:122/entropy--suffix/file"), (Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false));
    }

    @Test
    public void testCreateEntropyAwarePlainFs() throws Exception {
        File folder = TMP_FOLDER.newFolder();
        Path path = new Path(Path.fromLocalFile((File)folder), "_entropy_/file");
        OutputStreamAndPath out = EntropyInjector.createEntropyAware((FileSystem)LocalFileSystem.getSharedInstance(), (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        out.stream().close();
        Assert.assertEquals((Object)path, (Object)out.path());
        Assert.assertTrue((boolean)new File(new File(folder, "_entropy_"), "file").exists());
    }

    @Test
    public void testCreateEntropyAwareEntropyFs() throws Exception {
        File folder = TMP_FOLDER.newFolder();
        Path path = new Path(Path.fromLocalFile((File)folder), "_entropy_/file");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "test-entropy/file");
        TestEntropyInjectingFs fs = new TestEntropyInjectingFs("_entropy_", "test-entropy");
        OutputStreamAndPath out = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        out.stream().close();
        Assert.assertEquals((Object)new Path(Path.fromLocalFile((File)folder), "test-entropy/file"), (Object)out.path());
        Assert.assertTrue((boolean)new File(new File(folder, "test-entropy"), "file").exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithSafetyNet() throws Exception {
        FSDataOutputStream out;
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TMP_FOLDER.newFolder();
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("__ekey__", "abc");
        FileSystemSafetyNet.initializeSafetyNetForThread();
        FileSystem fs = FileSystemSafetyNet.wrapWithSafetyNetWhenActivated((FileSystem)efs);
        try {
            OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
            out = streamAndPath.stream();
            Assert.assertEquals((Object)pathWithEntropy, (Object)streamAndPath.path());
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
        try {
            out.write(42);
            out.flush();
            Assert.fail((String)"stream should be already close and hence fail with an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderFixingFsWithSafeyNet() throws Exception {
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TMP_FOLDER.newFolder();
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        PluginFileSystemFactory pluginFsFactory = PluginFileSystemFactory.of((FileSystemFactory)new TestFileSystemFactory("__ekey__", "abc"));
        FileSystem testFs = pluginFsFactory.create(URI.create("test"));
        FileSystemSafetyNet.initializeSafetyNetForThread();
        FileSystem fs = FileSystemSafetyNet.wrapWithSafetyNetWhenActivated((FileSystem)testFs);
        try {
            OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
            Assert.assertEquals((Object)pathWithEntropy, (Object)streamAndPath.path());
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
    }

    @Test
    public void testClassLoaderFixingFsWithoutSafeyNet() throws Exception {
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TMP_FOLDER.newFolder();
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        PluginFileSystemFactory pluginFsFactory = PluginFileSystemFactory.of((FileSystemFactory)new TestFileSystemFactory("__ekey__", "abc"));
        FileSystem testFs = pluginFsFactory.create(URI.create("test"));
        OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)testFs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        Assert.assertEquals((Object)pathWithEntropy, (Object)streamAndPath.path());
    }

    @Test
    public void testIsEntropyFs() {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("test", "ignored");
        Assert.assertTrue((boolean)EntropyInjector.isEntropyInjecting((FileSystem)efs));
    }

    @Test
    public void testIsEntropyFsWithNullEntropyKey() {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs(null, "ignored");
        Assert.assertFalse((boolean)EntropyInjector.isEntropyInjecting((FileSystem)efs));
    }

    private static class TestFileSystemFactory
    implements FileSystemFactory {
        private final String key;
        private final String entropy;

        TestFileSystemFactory(String key, String entropy) {
            this.key = key;
            this.entropy = entropy;
        }

        public String getScheme() {
            return null;
        }

        public FileSystem create(URI fsUri) {
            return new TestEntropyInjectingFs(this.key, this.entropy);
        }
    }

    private static final class TestEntropyInjectingFs
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        private final String key;
        private final String entropy;

        TestEntropyInjectingFs(String key, String entropy) {
            this.key = key;
            this.entropy = entropy;
        }

        public String getEntropyInjectionKey() {
            return this.key;
        }

        public String generateEntropy() {
            return this.entropy;
        }
    }
}

